/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming.messages;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.cassandra.io.util.DataOutputStreamAndChannel;
import org.apache.cassandra.streaming.StreamRequest;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.StreamSummary;
import org.apache.cassandra.streaming.messages.StreamMessage;

public class PrepareMessage
extends StreamMessage {
    public static StreamMessage.Serializer<PrepareMessage> serializer = new StreamMessage.Serializer<PrepareMessage>(){

        @Override
        public PrepareMessage deserialize(ReadableByteChannel in, int version, StreamSession session) throws IOException {
            DataInputStream input = new DataInputStream(Channels.newInputStream(in));
            PrepareMessage message = new PrepareMessage();
            int numRequests = input.readInt();
            for (int i = 0; i < numRequests; ++i) {
                message.requests.add(StreamRequest.serializer.deserialize(input, version));
            }
            int numSummaries = input.readInt();
            for (int i = 0; i < numSummaries; ++i) {
                message.summaries.add(StreamSummary.serializer.deserialize(input, version));
            }
            return message;
        }

        @Override
        public void serialize(PrepareMessage message, DataOutputStreamAndChannel out, int version, StreamSession session) throws IOException {
            out.writeInt(message.requests.size());
            for (StreamRequest request : message.requests) {
                StreamRequest.serializer.serialize(request, out, version);
            }
            out.writeInt(message.summaries.size());
            for (StreamSummary summary : message.summaries) {
                StreamSummary.serializer.serialize(summary, out, version);
            }
        }
    };
    public final Collection<StreamRequest> requests = new ArrayList<StreamRequest>();
    public final Collection<StreamSummary> summaries = new ArrayList<StreamSummary>();

    public PrepareMessage() {
        super(StreamMessage.Type.PREPARE);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Prepare (");
        sb.append(this.requests.size()).append(" requests, ");
        int totalFile = 0;
        for (StreamSummary summary : this.summaries) {
            totalFile += summary.files;
        }
        sb.append(" ").append(totalFile).append(" files");
        sb.append('}');
        return sb.toString();
    }
}

