/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tracing;

import com.google.common.base.Stopwatch;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.CFRowAdder;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.cassandra.utils.WrappedRunnable;
import org.slf4j.helpers.MessageFormatter;

public class TraceState {
    public final UUID sessionId;
    public final InetAddress coordinator;
    public final Stopwatch watch;
    public final ByteBuffer sessionIdBytes;
    private final AtomicInteger references = new AtomicInteger(1);

    public TraceState(InetAddress coordinator, UUID sessionId) {
        assert (coordinator != null);
        assert (sessionId != null);
        this.coordinator = coordinator;
        this.sessionId = sessionId;
        this.sessionIdBytes = ByteBufferUtil.bytes(sessionId);
        this.watch = Stopwatch.createStarted();
    }

    public int elapsed() {
        long elapsed = this.watch.elapsed(TimeUnit.MICROSECONDS);
        return elapsed < Integer.MAX_VALUE ? (int)elapsed : Integer.MAX_VALUE;
    }

    public void trace(String format, Object arg) {
        this.trace(MessageFormatter.format((String)format, (Object)arg).getMessage());
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.trace(MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage());
    }

    public void trace(String format, Object[] args) {
        this.trace(MessageFormatter.arrayFormat((String)format, (Object[])args).getMessage());
    }

    public void trace(String message) {
        TraceState.trace(this.sessionIdBytes, message, this.elapsed());
    }

    public static void trace(final ByteBuffer sessionIdBytes, final String message, final int elapsed) {
        final String threadName = Thread.currentThread().getName();
        StageManager.getStage(Stage.TRACING).execute(new WrappedRunnable(){

            @Override
            public void runMayThrow() {
                Mutation mutation = new Mutation("system_traces", sessionIdBytes);
                ColumnFamily cells = mutation.addOrGet(CFMetaData.TraceEventsCf);
                CFRowAdder adder = new CFRowAdder(cells, cells.metadata().comparator.make(UUIDGen.getTimeUUID()), FBUtilities.timestampMicros());
                adder.add("activity", message);
                adder.add("source", FBUtilities.getBroadcastAddress());
                if (elapsed >= 0) {
                    adder.add("source_elapsed", elapsed);
                }
                adder.add("thread", threadName);
                Tracing.mutateWithCatch(mutation);
            }
        });
    }

    public boolean acquireReference() {
        int n;
        do {
            if ((n = this.references.get()) > 0) continue;
            return false;
        } while (!this.references.compareAndSet(n, n + 1));
        return true;
    }

    public int releaseReference() {
        return this.references.decrementAndGet();
    }
}

