/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.rollup;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.client.rollup.job.config.RollupJobConfig;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;

public class GetRollupJobResponse {
    static final ParseField JOBS = new ParseField("jobs", new String[0]);
    static final ParseField CONFIG = new ParseField("config", new String[0]);
    static final ParseField STATS = new ParseField("stats", new String[0]);
    static final ParseField STATUS = new ParseField("status", new String[0]);
    static final ParseField NUM_PAGES = new ParseField("pages_processed", new String[0]);
    static final ParseField NUM_INPUT_DOCUMENTS = new ParseField("documents_processed", new String[0]);
    static final ParseField NUM_OUTPUT_DOCUMENTS = new ParseField("rollups_indexed", new String[0]);
    static final ParseField NUM_INVOCATIONS = new ParseField("trigger_count", new String[0]);
    static final ParseField STATE = new ParseField("job_state", new String[0]);
    static final ParseField CURRENT_POSITION = new ParseField("current_position", new String[0]);
    static final ParseField UPGRADED_DOC_ID = new ParseField("upgraded_doc_id", new String[0]);
    static final ParseField INDEX_TIME_IN_MS = new ParseField("index_time_in_ms", new String[0]);
    static final ParseField SEARCH_TIME_IN_MS = new ParseField("search_time_in_ms", new String[0]);
    static final ParseField INDEX_TOTAL = new ParseField("index_total", new String[0]);
    static final ParseField SEARCH_TOTAL = new ParseField("search_total", new String[0]);
    static final ParseField SEARCH_FAILURES = new ParseField("search_failures", new String[0]);
    static final ParseField INDEX_FAILURES = new ParseField("index_failures", new String[0]);
    private List<JobWrapper> jobs;
    private static final ConstructingObjectParser<GetRollupJobResponse, Void> PARSER = new ConstructingObjectParser("get_rollup_job_response", true, args -> {
        List jobs = (List)args[0];
        return new GetRollupJobResponse(Collections.unmodifiableList(jobs));
    });

    GetRollupJobResponse(List<JobWrapper> jobs) {
        this.jobs = Objects.requireNonNull(jobs, "jobs is required");
    }

    public List<JobWrapper> getJobs() {
        return this.jobs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetRollupJobResponse that = (GetRollupJobResponse)o;
        return this.jobs.equals(that.jobs);
    }

    public int hashCode() {
        return Objects.hash(this.jobs);
    }

    public static GetRollupJobResponse fromXContent(XContentParser parser) throws IOException {
        return (GetRollupJobResponse)PARSER.parse(parser, null);
    }

    public final String toString() {
        return "{jobs=" + this.jobs.stream().map(Object::toString).collect(Collectors.joining("\n")) + "\n}";
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (arg_0, arg_1) -> ((ConstructingObjectParser)JobWrapper.PARSER).apply(arg_0, arg_1), JOBS);
    }

    public static enum IndexerState {
        STARTED,
        INDEXING,
        STOPPING,
        STOPPED,
        ABORTING;


        static IndexerState fromString(String name) {
            return IndexerState.valueOf(name.trim().toUpperCase(Locale.ROOT));
        }

        String value() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static class RollupJobStatus {
        private final IndexerState state;
        private final Map<String, Object> currentPosition;
        private final boolean upgradedDocumentId;
        private static final ConstructingObjectParser<RollupJobStatus, Void> PARSER = new ConstructingObjectParser(STATUS.getPreferredName(), true, args -> {
            IndexerState state = (IndexerState)((Object)((Object)args[0]));
            Map currentPosition = (Map)args[1];
            Boolean upgradedDocumentId = (Boolean)args[2];
            return new RollupJobStatus(state, currentPosition, upgradedDocumentId == null ? false : upgradedDocumentId);
        });

        RollupJobStatus(IndexerState state, Map<String, Object> position, boolean upgradedDocumentId) {
            this.state = state;
            this.currentPosition = position;
            this.upgradedDocumentId = upgradedDocumentId;
        }

        public IndexerState getState() {
            return this.state;
        }

        public Map<String, Object> getCurrentPosition() {
            return this.currentPosition;
        }

        public boolean getUpgradedDocumentId() {
            return this.upgradedDocumentId;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            RollupJobStatus that = (RollupJobStatus)other;
            return Objects.equals((Object)this.state, (Object)that.state) && Objects.equals(this.currentPosition, that.currentPosition) && this.upgradedDocumentId == that.upgradedDocumentId;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.state, this.currentPosition, this.upgradedDocumentId});
        }

        public final String toString() {
            return "{stats=" + (Object)((Object)this.state) + ", currentPosition=" + this.currentPosition + ", upgradedDocumentId=" + this.upgradedDocumentId + "}";
        }

        static {
            PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> IndexerState.fromString(p.text()), STATE, ObjectParser.ValueType.STRING);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> {
                if (p.currentToken() == XContentParser.Token.START_OBJECT) {
                    return p.map();
                }
                if (p.currentToken() == XContentParser.Token.VALUE_NULL) {
                    return null;
                }
                throw new IllegalArgumentException("Unsupported token [" + p.currentToken() + "]");
            }, CURRENT_POSITION, ObjectParser.ValueType.VALUE_OBJECT_ARRAY);
            PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), UPGRADED_DOC_ID);
        }
    }

    public static class RollupIndexerJobStats {
        private final long numPages;
        private final long numInputDocuments;
        private final long numOuputDocuments;
        private final long numInvocations;
        private long indexTime;
        private long indexTotal;
        private long searchTime;
        private long searchTotal;
        private long indexFailures;
        private long searchFailures;
        private static final ConstructingObjectParser<RollupIndexerJobStats, Void> PARSER = new ConstructingObjectParser(STATS.getPreferredName(), true, args -> new RollupIndexerJobStats((Long)args[0], (Long)args[1], (Long)args[2], (Long)args[3], (Long)args[4], (Long)args[5], (Long)args[6], (Long)args[7], (Long)args[8], (Long)args[9]));

        RollupIndexerJobStats(long numPages, long numInputDocuments, long numOuputDocuments, long numInvocations, long indexTime, long indexTotal, long searchTime, long searchTotal, long indexFailures, long searchFailures) {
            this.numPages = numPages;
            this.numInputDocuments = numInputDocuments;
            this.numOuputDocuments = numOuputDocuments;
            this.numInvocations = numInvocations;
            this.indexTime = indexTime;
            this.indexTotal = indexTotal;
            this.searchTime = searchTime;
            this.searchTotal = searchTotal;
            this.indexFailures = indexFailures;
            this.searchFailures = searchFailures;
        }

        public long getNumPages() {
            return this.numPages;
        }

        public long getNumDocuments() {
            return this.numInputDocuments;
        }

        public long getNumInvocations() {
            return this.numInvocations;
        }

        public long getOutputDocuments() {
            return this.numOuputDocuments;
        }

        public long getIndexFailures() {
            return this.indexFailures;
        }

        public long getSearchFailures() {
            return this.searchFailures;
        }

        public long getIndexTime() {
            return this.indexTime;
        }

        public long getSearchTime() {
            return this.searchTime;
        }

        public long getIndexTotal() {
            return this.indexTotal;
        }

        public long getSearchTotal() {
            return this.searchTotal;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            RollupIndexerJobStats that = (RollupIndexerJobStats)other;
            return Objects.equals(this.numPages, that.numPages) && Objects.equals(this.numInputDocuments, that.numInputDocuments) && Objects.equals(this.numOuputDocuments, that.numOuputDocuments) && Objects.equals(this.numInvocations, that.numInvocations) && Objects.equals(this.indexTime, that.indexTime) && Objects.equals(this.searchTime, that.searchTime) && Objects.equals(this.indexFailures, that.indexFailures) && Objects.equals(this.searchFailures, that.searchFailures) && Objects.equals(this.searchTotal, that.searchTotal) && Objects.equals(this.indexTotal, that.indexTotal);
        }

        public int hashCode() {
            return Objects.hash(this.numPages, this.numInputDocuments, this.numOuputDocuments, this.numInvocations, this.indexTime, this.searchTime, this.indexFailures, this.searchFailures, this.searchTotal, this.indexTotal);
        }

        public final String toString() {
            return "{pages=" + this.numPages + ", input_docs=" + this.numInputDocuments + ", output_docs=" + this.numOuputDocuments + ", invocations=" + this.numInvocations + ", index_failures=" + this.indexFailures + ", search_failures=" + this.searchFailures + ", index_time_in_ms=" + this.indexTime + ", index_total=" + this.indexTotal + ", search_time_in_ms=" + this.searchTime + ", search_total=" + this.searchTotal + "}";
        }

        static {
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), NUM_PAGES);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), NUM_INPUT_DOCUMENTS);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), NUM_OUTPUT_DOCUMENTS);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), NUM_INVOCATIONS);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), INDEX_TIME_IN_MS);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), INDEX_TOTAL);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), SEARCH_TIME_IN_MS);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), SEARCH_TOTAL);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), INDEX_FAILURES);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), SEARCH_FAILURES);
        }
    }

    public static class JobWrapper {
        private final RollupJobConfig job;
        private final RollupIndexerJobStats stats;
        private final RollupJobStatus status;
        private static final ConstructingObjectParser<JobWrapper, Void> PARSER = new ConstructingObjectParser("job", true, a -> new JobWrapper((RollupJobConfig)a[0], (RollupIndexerJobStats)a[1], (RollupJobStatus)a[2]));

        JobWrapper(RollupJobConfig job, RollupIndexerJobStats stats, RollupJobStatus status) {
            this.job = job;
            this.stats = stats;
            this.status = status;
        }

        public RollupJobConfig getJob() {
            return this.job;
        }

        public RollupIndexerJobStats getStats() {
            return this.stats;
        }

        public RollupJobStatus getStatus() {
            return this.status;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JobWrapper other = (JobWrapper)obj;
            return Objects.equals(this.job, other.job) && Objects.equals(this.stats, other.stats) && Objects.equals(this.status, other.status);
        }

        public int hashCode() {
            return Objects.hash(this.job, this.stats, this.status);
        }

        public final String toString() {
            return "{job=" + this.job + ", stats=" + this.stats + ", status=" + this.status + "}";
        }

        static {
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> RollupJobConfig.fromXContent(p, null), CONFIG);
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (arg_0, arg_1) -> ((ConstructingObjectParser)RollupIndexerJobStats.PARSER).apply(arg_0, arg_1), STATS);
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (arg_0, arg_1) -> ((ConstructingObjectParser)RollupJobStatus.PARSER).apply(arg_0, arg_1), STATUS);
        }
    }
}

