/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.io.IOException;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public final class GetApiKeyRequest
implements Validatable,
ToXContentObject {
    private final String realmName;
    private final String userName;
    private final String id;
    private final String name;

    GetApiKeyRequest(@Nullable String realmName, @Nullable String userName, @Nullable String apiKeyId, @Nullable String apiKeyName) {
        if (!(Strings.hasText((String)realmName) || Strings.hasText((String)userName) || Strings.hasText((String)apiKeyId) || Strings.hasText((String)apiKeyName))) {
            this.throwValidationError("One of [api key id, api key name, username, realm name] must be specified");
        }
        if ((Strings.hasText((String)apiKeyId) || Strings.hasText((String)apiKeyName)) && (Strings.hasText((String)realmName) || Strings.hasText((String)userName))) {
            this.throwValidationError("username or realm name must not be specified when the api key id or api key name is specified");
        }
        if (Strings.hasText((String)apiKeyId) && Strings.hasText((String)apiKeyName)) {
            this.throwValidationError("only one of [api key id, api key name] can be specified");
        }
        this.realmName = realmName;
        this.userName = userName;
        this.id = apiKeyId;
        this.name = apiKeyName;
    }

    private void throwValidationError(String message) {
        throw new IllegalArgumentException(message);
    }

    public String getRealmName() {
        return this.realmName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static GetApiKeyRequest usingRealmName(String realmName) {
        return new GetApiKeyRequest(realmName, null, null, null);
    }

    public static GetApiKeyRequest usingUserName(String userName) {
        return new GetApiKeyRequest(null, userName, null, null);
    }

    public static GetApiKeyRequest usingRealmAndUserName(String realmName, String userName) {
        return new GetApiKeyRequest(realmName, userName, null, null);
    }

    public static GetApiKeyRequest usingApiKeyId(String apiKeyId) {
        return new GetApiKeyRequest(null, null, apiKeyId, null);
    }

    public static GetApiKeyRequest usingApiKeyName(String apiKeyName) {
        return new GetApiKeyRequest(null, null, null, apiKeyName);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder;
    }
}

