/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ElementValueComparator;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;
import org.apache.tinkerpop.gremlin.util.function.MultiComparator;
import org.janusgraph.graphdb.tinkerpop.optimize.HasStepFolder;

public class MultiDistinctOrderedIterator<E>
implements CloseableIterator<E> {
    private final Map<Integer, Iterator<E>> iterators = new LinkedHashMap<Integer, Iterator<E>>();
    private final Map<Integer, E> values = new LinkedHashMap<Integer, E>();
    private final TreeMap<E, Integer> currentElements;
    private final Set<E> allElements = new HashSet();
    private final Integer limit;
    private long count = 0L;

    public MultiDistinctOrderedIterator(Integer lowLimit, Integer highLimit, List<Iterator<E>> iterators, List<HasStepFolder.OrderEntry> orders) {
        this.limit = highLimit;
        ArrayList comp = new ArrayList();
        orders.forEach(o -> comp.add(new ElementValueComparator(o.key, (Comparator)o.order)));
        MultiComparator comparator = new MultiComparator(comp);
        for (int i = 0; i < iterators.size(); ++i) {
            this.iterators.put(i, iterators.get(i));
        }
        this.currentElements = new TreeMap(comparator);
        for (long i = 0L; i < (long)lowLimit.intValue() && this.hasNext(); ++i) {
            this.next();
        }
    }

    public boolean hasNext() {
        if (this.limit != null && this.count >= (long)this.limit.intValue()) {
            return false;
        }
        for (int i = 0; i < this.iterators.size(); ++i) {
            if (this.values.containsKey(i) || !this.iterators.get(i).hasNext()) continue;
            Object element = null;
            do {
                if (!this.allElements.contains(element = (Object)this.iterators.get(i).next())) continue;
                element = null;
            } while (element == null && this.iterators.get(i).hasNext());
            if (element == null) continue;
            this.values.put(i, element);
            this.currentElements.put(element, i);
            this.allElements.add(element);
        }
        return !this.values.isEmpty();
    }

    public E next() {
        ++this.count;
        return this.values.remove(this.currentElements.remove(this.currentElements.firstKey()));
    }

    public void close() {
        this.iterators.values().forEach(CloseableIterator::closeIterator);
    }
}

