/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Attribute;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Element;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementArray;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementList;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementListUnion;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementMapUnion;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementUnion;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Order;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Text;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Version;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.AttributeException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Contact;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Detail;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ElementException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Expression;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ExpressionBuilder;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Instantiator;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.InstantiatorBuilder;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Label;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.LabelMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Model;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ModelAssembler;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.PersistenceException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Scanner;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Structure;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Support;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.TextException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.TreeModel;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.UnionException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.strategy.Type;
import java.lang.annotation.Annotation;
import java.util.List;

class StructureBuilder {
    private InstantiatorBuilder resolver;
    private ExpressionBuilder builder;
    private ModelAssembler assembler;
    private Instantiator factory;
    private LabelMap attributes;
    private LabelMap elements;
    private LabelMap texts;
    private Scanner scanner;
    private Support support;
    private Label version;
    private Label text;
    private Model root;
    private boolean primitive;

    public StructureBuilder(Scanner scanner, Detail detail, Support support) {
        this.builder = new ExpressionBuilder(detail, support);
        this.assembler = new ModelAssembler(this.builder, detail, support);
        this.resolver = new InstantiatorBuilder(scanner, detail);
        this.root = new TreeModel(scanner, detail);
        this.attributes = new LabelMap(scanner);
        this.elements = new LabelMap(scanner);
        this.texts = new LabelMap(scanner);
        this.scanner = scanner;
        this.support = support;
    }

    public void assemble(Class clazz) {
        Order order = this.scanner.getOrder();
        if (order != null) {
            this.assembler.assemble(this.root, order);
        }
    }

    public void process(Contact contact, Annotation annotation) {
        if (annotation instanceof Attribute) {
            this.process(contact, annotation, this.attributes);
        }
        if (annotation instanceof ElementUnion) {
            this.union(contact, annotation, this.elements);
        }
        if (annotation instanceof ElementListUnion) {
            this.union(contact, annotation, this.elements);
        }
        if (annotation instanceof ElementMapUnion) {
            this.union(contact, annotation, this.elements);
        }
        if (annotation instanceof ElementList) {
            this.process(contact, annotation, this.elements);
        }
        if (annotation instanceof ElementArray) {
            this.process(contact, annotation, this.elements);
        }
        if (annotation instanceof ElementMap) {
            this.process(contact, annotation, this.elements);
        }
        if (annotation instanceof Element) {
            this.process(contact, annotation, this.elements);
        }
        if (annotation instanceof Version) {
            this.version(contact, annotation);
        }
        if (annotation instanceof Text) {
            this.text(contact, annotation);
        }
    }

    private void union(Contact contact, Annotation annotation, LabelMap labelMap) {
        List list = this.support.getLabels(contact, annotation);
        for (Label label : list) {
            String string = label.getPath();
            String string2 = label.getName();
            if (labelMap.get(string) != null) {
                throw new PersistenceException("Duplicate annotation of name '%s' on %s", string2, label);
            }
            this.process(contact, label, labelMap);
        }
    }

    private void process(Contact contact, Annotation annotation, LabelMap labelMap) {
        Label label = this.support.getLabel(contact, annotation);
        String string = label.getPath();
        String string2 = label.getName();
        if (labelMap.get(string) != null) {
            throw new PersistenceException("Duplicate annotation of name '%s' on %s", string2, contact);
        }
        this.process(contact, label, labelMap);
    }

    private void process(Contact contact, Label label, LabelMap labelMap) {
        Expression expression = label.getExpression();
        String string = label.getPath();
        Model model = this.root;
        if (!expression.isEmpty()) {
            model = this.register(expression);
        }
        this.resolver.register(label);
        model.register(label);
        labelMap.put(string, label);
    }

    private void text(Contact contact, Annotation annotation) {
        Label label = this.support.getLabel(contact, annotation);
        Expression expression = label.getExpression();
        String string = label.getPath();
        Model model = this.root;
        if (!expression.isEmpty()) {
            model = this.register(expression);
        }
        if (this.texts.get(string) != null) {
            throw new TextException("Multiple text annotations in %s", annotation);
        }
        this.resolver.register(label);
        model.register(label);
        this.texts.put(string, label);
    }

    private void version(Contact contact, Annotation annotation) {
        Label label = this.support.getLabel(contact, annotation);
        if (this.version != null) {
            throw new AttributeException("Multiple version annotations in %s", annotation);
        }
        this.version = label;
    }

    public Structure build(Class clazz) {
        return new Structure(this.factory, this.root, this.version, this.text, this.primitive);
    }

    private boolean isElement(String string) {
        Expression expression = this.builder.build(string);
        Model model = this.lookup(expression);
        if (model != null) {
            String string2 = expression.getLast();
            int n = expression.getIndex();
            if (model.isElement(string2)) {
                return true;
            }
            if (model.isModel(string2)) {
                Model model2 = model.lookup(string2, n);
                return !model2.isEmpty();
            }
        }
        return false;
    }

    private boolean isAttribute(String string) {
        Expression expression = this.builder.build(string);
        Model model = this.lookup(expression);
        if (model != null) {
            String string2 = expression.getLast();
            if (!expression.isPath()) {
                return model.isAttribute(string);
            }
            return model.isAttribute(string2);
        }
        return false;
    }

    private Model lookup(Expression expression) {
        Expression expression2 = expression.getPath(0, 1);
        if (expression.isPath()) {
            return this.root.lookup(expression2);
        }
        return this.root;
    }

    private Model register(Expression expression) {
        Model model = this.root.lookup(expression);
        if (model != null) {
            return model;
        }
        return this.create(expression);
    }

    private Model create(Expression expression) {
        Model model = this.root;
        while (model != null) {
            String string = expression.getPrefix();
            String string2 = expression.getFirst();
            int n = expression.getIndex();
            if (string2 != null) {
                model = model.register(string2, string, n);
            }
            if (!expression.isPath()) break;
            expression = expression.getPath(1);
        }
        return model;
    }

    public void commit(Class clazz) {
        if (this.factory == null) {
            this.factory = this.resolver.build();
        }
    }

    public void validate(Class clazz) {
        Order order = this.scanner.getOrder();
        this.validateUnions(clazz);
        this.validateElements(clazz, order);
        this.validateAttributes(clazz, order);
        this.validateModel(clazz);
        this.validateText(clazz);
        this.validateTextList(clazz);
    }

    private void validateModel(Class clazz) {
        if (!this.root.isEmpty()) {
            this.root.validate(clazz);
        }
    }

    private void validateText(Class clazz) {
        Label label = this.root.getText();
        if (label != null) {
            if (!label.isTextList()) {
                if (!this.elements.isEmpty()) {
                    throw new TextException("Elements used with %s in %s", label, clazz);
                }
                if (this.root.isComposite()) {
                    throw new TextException("Paths used with %s in %s", label, clazz);
                }
            }
        } else if (this.scanner.isEmpty()) {
            this.primitive = this.isEmpty();
        }
    }

    private void validateTextList(Class clazz) {
        Label label = this.root.getText();
        if (label != null && label.isTextList()) {
            Object object = label.getKey();
            for (Label label2 : this.elements) {
                Object object2 = label2.getKey();
                if (!object2.equals(object)) {
                    throw new TextException("Elements used with %s in %s", label, clazz);
                }
                Type type = label2.getDependent();
                Class clazz2 = type.getType();
                if (clazz2 != String.class) continue;
                throw new TextException("Illegal entry of %s with text annotations on %s in %s", clazz2, label, clazz);
            }
            if (this.root.isComposite()) {
                throw new TextException("Paths used with %s in %s", label, clazz);
            }
        }
    }

    private void validateUnions(Class clazz) {
        for (Label label : this.elements) {
            String[] stringArray = label.getPaths();
            Contact contact = label.getContact();
            for (String string : stringArray) {
                Annotation annotation = contact.getAnnotation();
                Label label2 = (Label)this.elements.get(string);
                if (label.isInline() != label2.isInline()) {
                    throw new UnionException("Inline must be consistent in %s for %s", annotation, contact);
                }
                if (label.isRequired() == label2.isRequired()) continue;
                throw new UnionException("Required must be consistent in %s for %s", annotation, contact);
            }
        }
    }

    private void validateElements(Class clazz, Order order) {
        if (order != null) {
            for (String string : order.elements()) {
                if (this.isElement(string)) continue;
                throw new ElementException("Ordered element '%s' missing for %s", string, clazz);
            }
        }
    }

    private void validateAttributes(Class clazz, Order order) {
        if (order != null) {
            for (String string : order.attributes()) {
                if (this.isAttribute(string)) continue;
                throw new AttributeException("Ordered attribute '%s' missing in %s", string, clazz);
            }
        }
    }

    private boolean isEmpty() {
        if (this.text != null) {
            return false;
        }
        return this.root.isEmpty();
    }
}

