/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.metrics.reporter.config;

import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricPredicate;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PredicateConfig
implements MetricPredicate {
    private static final Logger log = LoggerFactory.getLogger(PredicateConfig.class);
    @NotNull
    @Pattern(regexp="^(white|black)$", message="must one of: white, black")
    private String color;
    @NotNull
    @Size(min=1)
    private List<String> patterns;
    private boolean useQualifiedName;
    private List<java.util.regex.Pattern> cPatterns;

    public PredicateConfig() {
    }

    public PredicateConfig(String color, List<String> patterns) {
        this(color, patterns, false);
    }

    public PredicateConfig(String color, List<String> patterns, boolean useQualifiedName) {
        this.setColor(color);
        this.setPatterns(patterns);
        this.setUseQualifiedName(useQualifiedName);
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public List<String> getPatterns() {
        return this.patterns;
    }

    public void setPatterns(List<String> patterns) {
        this.patterns = patterns;
        this.cPatterns = new ArrayList<java.util.regex.Pattern>();
        for (String s : patterns) {
            this.cPatterns.add(java.util.regex.Pattern.compile(s));
        }
    }

    public boolean getUseQualifiedName() {
        return this.useQualifiedName;
    }

    public void setUseQualifiedName(boolean useQualifiedName) {
        this.useQualifiedName = useQualifiedName;
    }

    public boolean allowString(String name) {
        if (this.color.equals("black")) {
            for (java.util.regex.Pattern pat : this.cPatterns) {
                if (!pat.matcher(name).matches()) continue;
                return false;
            }
            return true;
        }
        if (this.color.equals("white")) {
            for (java.util.regex.Pattern pat : this.cPatterns) {
                if (!pat.matcher(name).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public String qualifyMetricName(MetricName mn) {
        String qualifiedTypeName = mn.getGroup() + "." + mn.getType();
        if (mn.hasScope()) {
            qualifiedTypeName = qualifiedTypeName + "." + mn.getScope();
        }
        qualifiedTypeName = qualifiedTypeName + "." + mn.getName();
        return qualifiedTypeName;
    }

    public boolean matches(MetricName name, Metric metric) {
        log.trace("Checking Metric name: {} {}", new Object[]{name.getName(), this.qualifyMetricName(name)});
        if (this.useQualifiedName) {
            return this.allowString(this.qualifyMetricName(name));
        }
        return this.allowString(name.getName());
    }
}

