/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.serializers;

import com.netflix.astyanax.serializers.AbstractSerializer;
import com.netflix.astyanax.serializers.ComparatorType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AsciiType;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public final class AsciiSerializer
extends AbstractSerializer<String> {
    private static final String US_ASCII = "US-ASCII";
    private static final AsciiSerializer instance = new AsciiSerializer();
    private static final Charset charset = Charset.forName("US-ASCII");

    public static AsciiSerializer get() {
        return instance;
    }

    @Override
    public String fromByteBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        ByteBuffer dup = byteBuffer.duplicate();
        return charset.decode(dup).toString();
    }

    @Override
    public ByteBuffer toByteBuffer(String obj) {
        if (obj == null) {
            return null;
        }
        return ByteBuffer.wrap(obj.getBytes(charset));
    }

    @Override
    public ComparatorType getComparatorType() {
        return ComparatorType.ASCIITYPE;
    }

    @Override
    public ByteBuffer fromString(String str) {
        return AsciiType.instance.fromString(str);
    }

    @Override
    public String getString(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        return AsciiType.instance.getString(byteBuffer.duplicate());
    }
}

