/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.serializers;

import com.google.common.base.Preconditions;
import com.netflix.astyanax.serializers.ComparatorType;
import com.netflix.astyanax.serializers.CompositeSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.CompositeType;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class SpecificCompositeSerializer
extends CompositeSerializer {
    private final CompositeType type;
    private List<String> comparators;

    public SpecificCompositeSerializer(CompositeType type) {
        Preconditions.checkNotNull((Object)type);
        this.type = type;
        this.comparators = new ArrayList<String>(type.types.size());
        for (AbstractType compType : type.types) {
            String typeName = compType.toString();
            this.comparators.add(ComparatorType.getShadedTypeName(typeName));
        }
    }

    @Override
    public ByteBuffer fromString(String string) {
        return this.type.fromString(string);
    }

    @Override
    public String getString(ByteBuffer byteBuffer) {
        return this.type.getString(byteBuffer);
    }

    @Override
    public List<String> getComparators() {
        return this.comparators;
    }
}

