/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cache;

import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.Memory;
import java.util.concurrent.atomic.AtomicInteger;

public class RefCountedMemory
extends Memory
implements AutoCloseable {
    private final AtomicInteger references = new AtomicInteger(1);

    public RefCountedMemory(long size) {
        super(size);
    }

    public boolean reference() {
        int n;
        do {
            if ((n = this.references.get()) > 0) continue;
            return false;
        } while (!this.references.compareAndSet(n, n + 1));
        return true;
    }

    public void unreference() {
        if (this.references.decrementAndGet() == 0) {
            this.free();
        }
    }

    @Override
    public void close() {
        this.unreference();
    }
}

