/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cache;

import com.netflix.astyanax.shaded.org.apache.cassandra.cache.CacheKey;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.Schema;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.DecoratedKey;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.FBUtilities;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ObjectSizes;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.Pair;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.UUID;

public class RowCacheKey
implements CacheKey,
Comparable<RowCacheKey> {
    public final UUID cfId;
    public final byte[] key;

    public RowCacheKey(UUID cfId, DecoratedKey key) {
        this(cfId, key.key);
    }

    public RowCacheKey(UUID cfId, ByteBuffer key) {
        this.cfId = cfId;
        this.key = ByteBufferUtil.getArray(key);
        assert (this.key != null);
    }

    @Override
    public Pair<String, String> getPathInfo() {
        return Schema.instance.getCF(this.cfId);
    }

    @Override
    public long memorySize() {
        return ObjectSizes.getFieldSize(ObjectSizes.getReferenceSize() + ObjectSizes.getReferenceSize()) + ObjectSizes.getArraySize(this.key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowCacheKey that = (RowCacheKey)o;
        return this.cfId.equals(that.cfId) && Arrays.equals(this.key, that.key);
    }

    public int hashCode() {
        int result = this.cfId.hashCode();
        result = 31 * result + (this.key != null ? Arrays.hashCode(this.key) : 0);
        return result;
    }

    @Override
    public int compareTo(RowCacheKey otherKey) {
        return this.cfId.compareTo(otherKey.cfId) < 0 ? -1 : (this.cfId.equals(otherKey.cfId) ? FBUtilities.compareUnsigned(this.key, otherKey.key, 0, 0, this.key.length, otherKey.key.length) : 1);
    }

    public String toString() {
        return String.format("RowCacheKey(cfId:%s, key:%s)", this.cfId, Arrays.toString(this.key));
    }
}

