/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cql3;

import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.ColumnIdentifier;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.ColumnSpecification;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.LongType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.ReversedType;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.pager.PagingState;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.Column;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.CqlMetadata;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.CqlResult;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.CqlResultType;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.CqlRow;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.CBCodec;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.CBUtil;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.DataType;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;

public class ResultSet {
    public static final Codec codec = new Codec();
    public static final ColumnIdentifier COUNT_COLUMN = new ColumnIdentifier("count", false);
    public final Metadata metadata;
    public final List<List<ByteBuffer>> rows;

    public ResultSet(List<ColumnSpecification> metadata) {
        this(new Metadata(metadata), new ArrayList<List<ByteBuffer>>());
    }

    public ResultSet(Metadata metadata, List<List<ByteBuffer>> rows) {
        this.metadata = metadata;
        this.rows = rows;
    }

    public int size() {
        return this.rows.size();
    }

    public void addRow(List<ByteBuffer> row) {
        assert (row.size() == this.metadata.columnCount);
        this.rows.add(row);
    }

    public void addColumnValue(ByteBuffer value) {
        if (this.rows.isEmpty() || this.lastRow().size() == this.metadata.columnCount) {
            this.rows.add(new ArrayList(this.metadata.columnCount));
        }
        this.lastRow().add(value);
    }

    private List<ByteBuffer> lastRow() {
        return this.rows.get(this.rows.size() - 1);
    }

    public void reverse() {
        Collections.reverse(this.rows);
    }

    public void trim(int limit) {
        int toRemove = this.rows.size() - limit;
        if (toRemove > 0) {
            for (int i = 0; i < toRemove; ++i) {
                this.rows.remove(this.rows.size() - 1);
            }
        }
    }

    public ResultSet makeCountResult(ColumnIdentifier alias) {
        assert (this.metadata.names != null);
        String ksName = this.metadata.names.get((int)0).ksName;
        String cfName = this.metadata.names.get((int)0).cfName;
        long count = this.rows.size();
        return ResultSet.makeCountResult(ksName, cfName, count, alias);
    }

    public static Metadata makeCountMetadata(String ksName, String cfName, ColumnIdentifier alias) {
        ColumnSpecification spec = new ColumnSpecification(ksName, cfName, alias == null ? COUNT_COLUMN : alias, LongType.instance);
        return new Metadata(Collections.singletonList(spec));
    }

    public static ResultSet makeCountResult(String ksName, String cfName, long count, ColumnIdentifier alias) {
        List<List<ByteBuffer>> newRows = Collections.singletonList(Collections.singletonList(ByteBufferUtil.bytes(count)));
        return new ResultSet(ResultSet.makeCountMetadata(ksName, cfName, alias), newRows);
    }

    public CqlResult toThriftResult() {
        assert (this.metadata.names != null);
        String UTF8 = "UTF8Type";
        CqlMetadata schema = new CqlMetadata(new HashMap(), new HashMap(), UTF8, UTF8);
        for (ColumnSpecification name : this.metadata.names) {
            ByteBuffer colName = ByteBufferUtil.bytes(name.toString());
            schema.name_types.put(colName, UTF8);
            AbstractType<?> normalizedType = name.type instanceof ReversedType ? ((ReversedType)name.type).baseType : name.type;
            schema.value_types.put(colName, normalizedType.toString());
        }
        ArrayList<CqlRow> cqlRows = new ArrayList<CqlRow>(this.rows.size());
        for (List<ByteBuffer> row : this.rows) {
            ArrayList<Column> thriftCols = new ArrayList<Column>(this.metadata.names.size());
            for (int i = 0; i < this.metadata.names.size(); ++i) {
                Column col = new Column(ByteBufferUtil.bytes(this.metadata.names.get(i).toString()));
                col.setValue(row.get(i));
                thriftCols.add(col);
            }
            cqlRows.add(new CqlRow(ByteBufferUtil.EMPTY_BYTE_BUFFER, thriftCols));
        }
        CqlResult res = new CqlResult(CqlResultType.ROWS);
        res.setRows(cqlRows).setSchema(schema);
        return res;
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(this.metadata).append('\n');
            for (List<ByteBuffer> row : this.rows) {
                for (int i = 0; i < row.size(); ++i) {
                    ByteBuffer v = row.get(i);
                    if (v == null) {
                        sb.append(" | null");
                        continue;
                    }
                    sb.append(" | ");
                    if (this.metadata.flags.contains((Object)Flag.NO_METADATA)) {
                        sb.append("0x").append(ByteBufferUtil.bytesToHex(v));
                        continue;
                    }
                    sb.append(this.metadata.names.get((int)i).type.getString(v));
                }
                sb.append('\n');
            }
            sb.append("---");
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static enum Flag {
        GLOBAL_TABLES_SPEC,
        HAS_MORE_PAGES,
        NO_METADATA;


        public static EnumSet<Flag> deserialize(int flags) {
            EnumSet<Flag> set = EnumSet.noneOf(Flag.class);
            Flag[] values = Flag.values();
            for (int n = 0; n < values.length; ++n) {
                if ((flags & 1 << n) == 0) continue;
                set.add(values[n]);
            }
            return set;
        }

        public static int serialize(EnumSet<Flag> flags) {
            int i = 0;
            for (Flag flag : flags) {
                i |= 1 << flag.ordinal();
            }
            return i;
        }
    }

    public static class Metadata {
        public static final CBCodec<Metadata> codec = new Codec();
        public static final Metadata EMPTY = new Metadata(EnumSet.of(Flag.NO_METADATA), 0);
        public final EnumSet<Flag> flags;
        public final List<ColumnSpecification> names;
        public final int columnCount;
        public PagingState pagingState;

        public Metadata(List<ColumnSpecification> names) {
            this(EnumSet.noneOf(Flag.class), names);
            if (!names.isEmpty() && this.allInSameCF()) {
                this.flags.add(Flag.GLOBAL_TABLES_SPEC);
            }
        }

        private Metadata(EnumSet<Flag> flags, List<ColumnSpecification> names) {
            this.flags = flags;
            this.names = names;
            this.columnCount = names.size();
        }

        private Metadata(EnumSet<Flag> flags, int columnCount) {
            this.flags = flags;
            this.names = null;
            this.columnCount = columnCount;
        }

        private boolean allInSameCF() {
            if (this.names == null) {
                return false;
            }
            assert (!this.names.isEmpty());
            Iterator<ColumnSpecification> iter = this.names.iterator();
            ColumnSpecification first = iter.next();
            while (iter.hasNext()) {
                ColumnSpecification name = iter.next();
                if (name.ksName.equals(first.ksName) && name.cfName.equals(first.cfName)) continue;
                return false;
            }
            return true;
        }

        public Metadata setHasMorePages(PagingState pagingState) {
            this.pagingState = pagingState;
            if (pagingState == null) {
                this.flags.remove((Object)Flag.HAS_MORE_PAGES);
            } else {
                this.flags.add(Flag.HAS_MORE_PAGES);
            }
            return this;
        }

        public void setSkipMetadata() {
            this.flags.add(Flag.NO_METADATA);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.names == null) {
                sb.append("[").append(this.columnCount).append(" columns]");
            } else {
                for (ColumnSpecification name : this.names) {
                    sb.append("[").append(name.toString());
                    sb.append("(").append(name.ksName).append(", ").append(name.cfName).append(")");
                    sb.append(", ").append(name.type).append("]");
                }
            }
            if (this.flags.contains((Object)Flag.HAS_MORE_PAGES)) {
                sb.append(" (to be continued)");
            }
            return sb.toString();
        }

        private static class Codec
        implements CBCodec<Metadata> {
            private Codec() {
            }

            @Override
            public Metadata decode(ChannelBuffer body, int version) {
                int iflags = body.readInt();
                int columnCount = body.readInt();
                EnumSet<Flag> flags = Flag.deserialize(iflags);
                PagingState state = null;
                if (flags.contains((Object)Flag.HAS_MORE_PAGES)) {
                    state = PagingState.deserialize(CBUtil.readValue(body));
                }
                if (flags.contains((Object)Flag.NO_METADATA)) {
                    return new Metadata(flags, columnCount).setHasMorePages(state);
                }
                boolean globalTablesSpec = flags.contains((Object)Flag.GLOBAL_TABLES_SPEC);
                String globalKsName = null;
                String globalCfName = null;
                if (globalTablesSpec) {
                    globalKsName = CBUtil.readString(body);
                    globalCfName = CBUtil.readString(body);
                }
                ArrayList<ColumnSpecification> names = new ArrayList<ColumnSpecification>(columnCount);
                for (int i = 0; i < columnCount; ++i) {
                    String ksName = globalTablesSpec ? globalKsName : CBUtil.readString(body);
                    String cfName = globalTablesSpec ? globalCfName : CBUtil.readString(body);
                    ColumnIdentifier colName = new ColumnIdentifier(CBUtil.readString(body), true);
                    AbstractType type = DataType.toType(DataType.codec.decodeOne(body));
                    names.add(new ColumnSpecification(ksName, cfName, colName, type));
                }
                return new Metadata(flags, names).setHasMorePages(state);
            }

            @Override
            public void encode(Metadata m, ChannelBuffer dest, int version) {
                boolean noMetadata = m.flags.contains((Object)Flag.NO_METADATA);
                boolean globalTablesSpec = m.flags.contains((Object)Flag.GLOBAL_TABLES_SPEC);
                boolean hasMorePages = m.flags.contains((Object)Flag.HAS_MORE_PAGES);
                assert (version > 1 || !m.flags.contains((Object)Flag.HAS_MORE_PAGES) && !noMetadata) : "version = " + version + ", flags = " + m.flags;
                dest.writeInt(Flag.serialize(m.flags));
                dest.writeInt(m.columnCount);
                if (hasMorePages) {
                    CBUtil.writeValue(m.pagingState.serialize(), dest);
                }
                if (!noMetadata) {
                    if (globalTablesSpec) {
                        CBUtil.writeString(m.names.get((int)0).ksName, dest);
                        CBUtil.writeString(m.names.get((int)0).cfName, dest);
                    }
                    for (ColumnSpecification name : m.names) {
                        if (!globalTablesSpec) {
                            CBUtil.writeString(name.ksName, dest);
                            CBUtil.writeString(name.cfName, dest);
                        }
                        CBUtil.writeString(name.toString(), dest);
                        DataType.codec.writeOne(DataType.fromType(name.type), dest);
                    }
                }
            }

            @Override
            public int encodedSize(Metadata m, int version) {
                boolean noMetadata = m.flags.contains((Object)Flag.NO_METADATA);
                boolean globalTablesSpec = m.flags.contains((Object)Flag.GLOBAL_TABLES_SPEC);
                boolean hasMorePages = m.flags.contains((Object)Flag.HAS_MORE_PAGES);
                int size = 8;
                if (hasMorePages) {
                    size += CBUtil.sizeOfValue(m.pagingState.serialize());
                }
                if (!noMetadata) {
                    if (globalTablesSpec) {
                        size += CBUtil.sizeOfString(m.names.get((int)0).ksName);
                        size += CBUtil.sizeOfString(m.names.get((int)0).cfName);
                    }
                    for (ColumnSpecification name : m.names) {
                        if (!globalTablesSpec) {
                            size += CBUtil.sizeOfString(name.ksName);
                            size += CBUtil.sizeOfString(name.cfName);
                        }
                        size += CBUtil.sizeOfString(name.toString());
                        size += DataType.codec.oneSerializedSize(DataType.fromType(name.type));
                    }
                }
                return size;
            }
        }
    }

    public static class Codec
    implements CBCodec<ResultSet> {
        @Override
        public ResultSet decode(ChannelBuffer body, int version) {
            Metadata m = Metadata.codec.decode(body, version);
            int rowCount = body.readInt();
            ResultSet rs = new ResultSet(m, new ArrayList<List<ByteBuffer>>(rowCount));
            int totalValues = rowCount * m.columnCount;
            for (int i = 0; i < totalValues; ++i) {
                rs.addColumnValue(CBUtil.readValue(body));
            }
            return rs;
        }

        @Override
        public void encode(ResultSet rs, ChannelBuffer dest, int version) {
            Metadata.codec.encode(rs.metadata, dest, version);
            dest.writeInt(rs.rows.size());
            for (List<ByteBuffer> row : rs.rows) {
                for (ByteBuffer bb : row) {
                    CBUtil.writeValue(bb, dest);
                }
            }
        }

        @Override
        public int encodedSize(ResultSet rs, int version) {
            int size = Metadata.codec.encodedSize(rs.metadata, version) + 4;
            for (List<ByteBuffer> row : rs.rows) {
                for (ByteBuffer bb : row) {
                    size += CBUtil.sizeOfValue(bb);
                }
            }
            return size;
        }
    }
}

