/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements;

import com.netflix.astyanax.shaded.org.apache.cassandra.auth.Permission;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.CFMetaData;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.ColumnDefinition;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.CFDefinition;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.CFName;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.CQL3Type;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.ColumnIdentifier;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.CFPropDefs;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.CollectionType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.ColumnToCollectionType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.CompositeType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.CounterColumnType;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.ConfigurationException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.InvalidRequestException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.RequestValidationException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.UnauthorizedException;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.ClientState;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.MigrationManager;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.ThriftValidation;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.ResultMessage;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlterTableStatement
extends SchemaAlteringStatement {
    public final Type oType;
    public final CQL3Type validator;
    public final ColumnIdentifier.Raw rawColumnName;
    private final CFPropDefs cfProps;
    private final Map<ColumnIdentifier.Raw, ColumnIdentifier.Raw> renames;
    private final boolean isStatic;

    public AlterTableStatement(CFName name, Type type, ColumnIdentifier.Raw columnName, CQL3Type validator, CFPropDefs cfProps, Map<ColumnIdentifier.Raw, ColumnIdentifier.Raw> renames, boolean isStatic) {
        super(name);
        this.oType = type;
        this.rawColumnName = columnName;
        this.validator = validator;
        this.cfProps = cfProps;
        this.renames = renames;
        this.isStatic = isStatic;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.ALTER);
    }

    @Override
    public void validate(ClientState state) {
    }

    @Override
    public boolean announceMigration() throws RequestValidationException {
        CFMetaData meta = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
        CFMetaData cfm = meta.clone();
        CFDefinition cfDef = meta.getCfDef();
        ColumnIdentifier columnName = null;
        CFDefinition.Name name = null;
        if (this.rawColumnName != null) {
            columnName = this.rawColumnName.prepare(cfm);
            name = cfDef.get(columnName);
        }
        switch (this.oType) {
            case ADD: {
                assert (columnName != null);
                if (cfDef.isCompact) {
                    throw new InvalidRequestException("Cannot add new column to a COMPACT STORAGE table");
                }
                if (this.isStatic) {
                    if (!cfDef.isComposite) {
                        throw new InvalidRequestException("Static columns are not allowed in COMPACT STORAGE tables");
                    }
                    if (cfDef.clusteringColumns().isEmpty()) {
                        throw new InvalidRequestException("Static columns are only useful (and thus allowed) if the table has at least one clustering column");
                    }
                }
                if (name != null) {
                    switch (name.kind) {
                        case KEY_ALIAS: 
                        case COLUMN_ALIAS: {
                            throw new InvalidRequestException(String.format("Invalid column name %s because it conflicts with a PRIMARY KEY part", columnName));
                        }
                    }
                    throw new InvalidRequestException(String.format("Invalid column name %s because it conflicts with an existing column", columnName));
                }
                if (meta.getDefaultValidator().isCommutative() && meta.getDroppedColumns().containsKey(columnName.key)) {
                    throw new InvalidRequestException(String.format("Cannot re-add previously dropped counter column %s", columnName));
                }
                AbstractType<?> type = this.validator.getType();
                if (type instanceof CollectionType) {
                    if (!cfDef.isComposite) {
                        throw new InvalidRequestException("Cannot use collection types with non-composite PRIMARY KEY");
                    }
                    if (cfDef.cfm.isSuper()) {
                        throw new InvalidRequestException("Cannot use collection types with Super column family");
                    }
                    HashMap<ByteBuffer, CollectionType> collections = cfDef.hasCollections ? new HashMap<ByteBuffer, CollectionType>(cfDef.getCollectionType().defined) : new HashMap();
                    CollectionType previous = (CollectionType)collections.get(columnName.key);
                    if (previous != null && !type.isCompatibleWith(previous)) {
                        throw new InvalidRequestException(String.format("Cannot add a collection with the name %s because a collection with the same name and a different type has already been used in the past", columnName));
                    }
                    collections.put(columnName.key, (CollectionType)type);
                    ColumnToCollectionType newColType = ColumnToCollectionType.getInstance(collections);
                    ArrayList ctypes = new ArrayList(((CompositeType)cfm.comparator).types);
                    if (cfDef.hasCollections) {
                        ctypes.set(ctypes.size() - 1, newColType);
                    } else {
                        ctypes.add(newColType);
                    }
                    cfm.comparator = CompositeType.getInstance(ctypes);
                }
                Integer componentIndex = cfDef.isComposite ? Integer.valueOf(((CompositeType)meta.comparator).types.size() - (cfDef.hasCollections ? 2 : 1)) : null;
                cfm.addColumnDefinition(this.isStatic ? ColumnDefinition.staticDef(columnName.key, type, componentIndex) : ColumnDefinition.regularDef(columnName.key, type, componentIndex));
                break;
            }
            case ALTER: {
                assert (columnName != null);
                if (name == null) {
                    throw new InvalidRequestException(String.format("Column %s was not found in table %s", columnName, this.columnFamily()));
                }
                switch (name.kind) {
                    case KEY_ALIAS: {
                        AbstractType<?> newType = this.validator.getType();
                        if (newType instanceof CounterColumnType) {
                            throw new InvalidRequestException(String.format("counter type is not supported for PRIMARY KEY part %s", columnName));
                        }
                        if (cfDef.hasCompositeKey) {
                            List<AbstractType<?>> oldTypes = ((CompositeType)cfm.getKeyValidator()).types;
                            if (!newType.isValueCompatibleWith(oldTypes.get(name.position))) {
                                throw new ConfigurationException(String.format("Cannot change %s from type %s to type %s: types are incompatible.", columnName, oldTypes.get(name.position).asCQL3Type(), this.validator));
                            }
                            ArrayList newTypes = new ArrayList(oldTypes);
                            newTypes.set(name.position, newType);
                            cfm.keyValidator(CompositeType.getInstance(newTypes));
                            break;
                        }
                        if (!newType.isValueCompatibleWith(cfm.getKeyValidator())) {
                            throw new ConfigurationException(String.format("Cannot change %s from type %s to type %s: types are incompatible.", columnName, cfm.getKeyValidator().asCQL3Type(), this.validator));
                        }
                        cfm.keyValidator(newType);
                        break;
                    }
                    case COLUMN_ALIAS: {
                        assert (cfDef.isComposite);
                        List<AbstractType<?>> oldTypes = ((CompositeType)cfm.comparator).types;
                        if (!this.validator.getType().isCompatibleWith(oldTypes.get(name.position))) {
                            throw new ConfigurationException(String.format("Cannot change %s from type %s to type %s: types are not order-compatible.", columnName, oldTypes.get(name.position).asCQL3Type(), this.validator));
                        }
                        ArrayList newTypes = new ArrayList(oldTypes);
                        newTypes.set(name.position, this.validator.getType());
                        cfm.comparator = CompositeType.getInstance(newTypes);
                        break;
                    }
                    case VALUE_ALIAS: {
                        if (!this.validator.getType().isValueCompatibleWith(cfm.getDefaultValidator())) {
                            throw new ConfigurationException(String.format("Cannot change %s from type %s to type %s: types are incompatible.", columnName, cfm.getDefaultValidator().asCQL3Type(), this.validator));
                        }
                        cfm.defaultValidator(this.validator.getType());
                        break;
                    }
                    case COLUMN_METADATA: 
                    case STATIC: {
                        ColumnDefinition column = cfm.getColumnDefinition(columnName.key);
                        if (!this.validator.getType().isValueCompatibleWith(column.getValidator())) {
                            throw new ConfigurationException(String.format("Cannot change %s from type %s to type %s: types are incompatible.", columnName, column.getValidator().asCQL3Type(), this.validator));
                        }
                        column.setValidator(this.validator.getType());
                    }
                }
                break;
            }
            case DROP: {
                assert (columnName != null);
                if (cfDef.isCompact || !cfDef.isComposite) {
                    throw new InvalidRequestException("Cannot drop columns from a COMPACT STORAGE table");
                }
                if (name == null) {
                    throw new InvalidRequestException(String.format("Column %s was not found in table %s", columnName, this.columnFamily()));
                }
                switch (name.kind) {
                    case KEY_ALIAS: 
                    case COLUMN_ALIAS: {
                        throw new InvalidRequestException(String.format("Cannot drop PRIMARY KEY part %s", columnName));
                    }
                    case COLUMN_METADATA: 
                    case STATIC: {
                        ColumnDefinition toDelete = null;
                        for (ColumnDefinition columnDef : cfm.regularAndStaticColumns()) {
                            if (!columnDef.name.equals(columnName.key)) continue;
                            toDelete = columnDef;
                        }
                        assert (toDelete != null);
                        cfm.removeColumnDefinition(toDelete);
                        cfm.recordColumnDrop(toDelete);
                    }
                }
                break;
            }
            case OPTS: {
                if (this.cfProps == null) {
                    throw new InvalidRequestException(String.format("ALTER COLUMNFAMILY WITH invoked, but no parameters found", new Object[0]));
                }
                this.cfProps.validate();
                if (meta.isCounter() && this.cfProps.getDefaultTimeToLive() > 0) {
                    throw new InvalidRequestException("Cannot set default_time_to_live on a table with counters");
                }
                this.cfProps.applyToCFMetadata(cfm);
                break;
            }
            case RENAME: {
                for (Map.Entry<ColumnIdentifier.Raw, ColumnIdentifier.Raw> entry : this.renames.entrySet()) {
                    ColumnIdentifier from = entry.getKey().prepare(cfm);
                    ColumnIdentifier to = entry.getValue().prepare(cfm);
                    cfm.renameColumn(from.key, from.toString(), to.key, to.toString());
                }
                break;
            }
        }
        MigrationManager.announceColumnFamilyUpdate(cfm, false);
        return true;
    }

    public String toString() {
        return String.format("AlterTableStatement(name=%s, type=%s, column=%s, validator=%s)", new Object[]{this.cfName, this.oType, this.rawColumnName, this.validator});
    }

    @Override
    public ResultMessage.SchemaChange.Change changeType() {
        return ResultMessage.SchemaChange.Change.UPDATED;
    }

    public static enum Type {
        ADD,
        ALTER,
        DROP,
        OPTS,
        RENAME;

    }
}

