/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.DatabaseDescriptor;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.Attributes;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.CQLStatement;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.ColumnIdentifier;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.ColumnNameBuilder;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.MeasurableForPreparedCache;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.QueryOptions;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.UpdateParameters;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.VariableSpecifications;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.CFStatement;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.CQL3CasConditions;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.ModificationStatement;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.ParsedStatement;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamily;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ConsistencyLevel;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.CounterMutation;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.IMutation;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.RowMutation;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.UnsortedColumns;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.InvalidRequestException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.RequestExecutionException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.RequestValidationException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.UnauthorizedException;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.ClientState;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.QueryState;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.StorageProxy;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.ResultMessage;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.github.jamm.MemoryMeter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchStatement
implements CQLStatement,
MeasurableForPreparedCache {
    private static boolean loggedCASTimestamp = false;
    private static boolean loggedCounterTimestamp = false;
    private final int boundTerms;
    public final Type type;
    private final List<ModificationStatement> statements;
    private final Attributes attrs;
    private final boolean hasConditions;
    private static final Logger logger = LoggerFactory.getLogger(BatchStatement.class);

    public BatchStatement(int boundTerms, Type type, List<ModificationStatement> statements, Attributes attrs, boolean hasConditions) {
        this.boundTerms = boundTerms;
        this.type = type;
        this.statements = statements;
        this.attrs = attrs;
        this.hasConditions = hasConditions;
    }

    @Override
    public long measureForPreparedCache(MemoryMeter meter) {
        long size = meter.measure((Object)this) + meter.measureDeep((Object)this.type) + meter.measure(this.statements) + meter.measureDeep((Object)this.attrs);
        for (ModificationStatement stmt : this.statements) {
            size += stmt.measureForPreparedCache(meter);
        }
        return size;
    }

    @Override
    public int getBoundTerms() {
        return this.boundTerms;
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException, UnauthorizedException {
        for (ModificationStatement statement : this.statements) {
            statement.checkAccess(state);
        }
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
        if (this.attrs.isTimeToLiveSet()) {
            throw new InvalidRequestException("Global TTL on the BATCH statement is not supported.");
        }
        boolean timestampSet = this.attrs.isTimestampSet();
        if (timestampSet) {
            if (this.hasConditions && !loggedCASTimestamp) {
                logger.warn("Detected use of 'USING TIMESTAMP' on a BATCH with conditions. This is invalid, custom timestamps are not allowed when conditions are used and the timestamp has been ignored. Such queries will be rejected in Cassandra 2.1+ - please fix your queries before then.");
                loggedCASTimestamp = true;
            }
            if (this.type == Type.COUNTER && !loggedCounterTimestamp) {
                logger.warn("Detected use of 'USING TIMESTAMP' in a counter BATCH. This is invalid because counters do not use timestamps, and the timestamp has been ignored. Such queries will be rejected in Cassandra 2.1+ - please fix your queries before then.");
                loggedCounterTimestamp = true;
            }
        }
        for (ModificationStatement statement : this.statements) {
            if (timestampSet && statement.isTimestampSet()) {
                throw new InvalidRequestException("Timestamp must be set either on BATCH or individual statements");
            }
            statement.validate(state);
            if (!this.hasConditions || !statement.requiresRead()) continue;
            throw new InvalidRequestException("Operations on lists requiring a read (setting by index and deletions by index or value) are not allowed with IF conditions");
        }
    }

    public List<ModificationStatement> getStatements() {
        return this.statements;
    }

    private Collection<? extends IMutation> getMutations(BatchVariables variables, boolean local, ConsistencyLevel cl, long now) throws RequestExecutionException, RequestValidationException {
        HashMap<String, Map<ByteBuffer, IMutation>> mutations = new HashMap<String, Map<ByteBuffer, IMutation>>();
        for (int i = 0; i < this.statements.size(); ++i) {
            ModificationStatement statement = this.statements.get(i);
            List<ByteBuffer> statementVariables = variables.getVariablesForStatement(i);
            long timestamp = this.attrs.getTimestamp(now, statementVariables);
            this.addStatementMutations(statement, statementVariables, local, cl, timestamp, mutations);
        }
        return this.unzipMutations(mutations);
    }

    private Collection<? extends IMutation> unzipMutations(Map<String, Map<ByteBuffer, IMutation>> mutations) {
        if (mutations.size() == 1) {
            return mutations.values().iterator().next().values();
        }
        ArrayList<IMutation> ms = new ArrayList<IMutation>();
        for (Map<ByteBuffer, IMutation> ksMap : mutations.values()) {
            ms.addAll(ksMap.values());
        }
        return ms;
    }

    private void addStatementMutations(ModificationStatement statement, List<ByteBuffer> variables, boolean local, ConsistencyLevel cl, long now, Map<String, Map<ByteBuffer, IMutation>> mutations) throws RequestExecutionException, RequestValidationException {
        String ksName = statement.keyspace();
        Map<ByteBuffer, IMutation> ksMap = mutations.get(ksName);
        if (ksMap == null) {
            ksMap = new HashMap<ByteBuffer, IMutation>();
            mutations.put(ksName, ksMap);
        }
        List<ByteBuffer> keys = statement.buildPartitionKeyNames(variables);
        ColumnNameBuilder clusteringPrefix = statement.createClusteringPrefixBuilder(variables);
        UpdateParameters params = statement.makeUpdateParameters(keys, clusteringPrefix, variables, local, cl, now);
        for (ByteBuffer key : keys) {
            RowMutation rm;
            IMutation mutation = ksMap.get(key);
            if (mutation == null) {
                rm = new RowMutation(ksName, key);
                mutation = this.type == Type.COUNTER ? new CounterMutation(rm, cl) : rm;
                ksMap.put(key, mutation);
            } else {
                rm = this.type == Type.COUNTER ? ((CounterMutation)mutation).rowMutation() : (RowMutation)mutation;
            }
            statement.addUpdateForKey(rm.addOrGet(statement.cfm, UnsortedColumns.factory), key, clusteringPrefix, params);
        }
    }

    private void verifyBatchSize(Iterable<ColumnFamily> cfs) {
        long size = 0L;
        long warnThreshold = DatabaseDescriptor.getBatchSizeWarnThreshold();
        for (ColumnFamily cf : cfs) {
            size += cf.dataSize();
        }
        if (size > warnThreshold) {
            HashSet<String> ksCfPairs = new HashSet<String>();
            for (ColumnFamily cf : cfs) {
                ksCfPairs.add(cf.metadata().ksName + "." + cf.metadata().cfName);
            }
            String format = "Batch of prepared statements for {} is of size {}, exceeding specified threshold of {} by {}.";
            logger.warn(format, new Object[]{ksCfPairs, size, warnThreshold, size - warnThreshold});
        }
    }

    @Override
    public ResultMessage execute(QueryState queryState, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        if (options.getConsistency() == null) {
            throw new InvalidRequestException("Invalid empty consistency level");
        }
        return this.execute(new PreparedBatchVariables(options.getValues()), false, options.getConsistency(), options.getSerialConsistency(), queryState.getTimestamp());
    }

    public ResultMessage executeWithPerStatementVariables(ConsistencyLevel cl, QueryState queryState, List<List<ByteBuffer>> variables) throws RequestExecutionException, RequestValidationException {
        if (cl == null) {
            throw new InvalidRequestException("Invalid empty consistency level");
        }
        return this.execute(new BatchOfPreparedVariables(variables), false, cl, ConsistencyLevel.SERIAL, queryState.getTimestamp());
    }

    public ResultMessage execute(BatchVariables variables, boolean local, ConsistencyLevel cl, ConsistencyLevel serialCl, long now) throws RequestExecutionException, RequestValidationException {
        if (this.hasConditions) {
            return this.executeWithConditions(variables, cl, serialCl, now);
        }
        this.executeWithoutConditions(this.getMutations(variables, local, cl, now), cl);
        return new ResultMessage.Void();
    }

    private void executeWithoutConditions(Collection<? extends IMutation> mutations, ConsistencyLevel cl) throws RequestExecutionException, RequestValidationException {
        Iterable cfs = Iterables.concat((Iterable)Iterables.transform(mutations, (Function)new Function<IMutation, Collection<ColumnFamily>>(){

            public Collection<ColumnFamily> apply(IMutation im) {
                return im.getColumnFamilies();
            }
        }));
        this.verifyBatchSize(cfs);
        boolean mutateAtomic = this.type == Type.LOGGED && mutations.size() > 1;
        StorageProxy.mutateWithTriggers(mutations, cl, mutateAtomic);
    }

    private ResultMessage executeWithConditions(BatchVariables variables, ConsistencyLevel cl, ConsistencyLevel serialCf, long now) throws RequestExecutionException, RequestValidationException {
        ByteBuffer key = null;
        String ksName = null;
        String cfName = null;
        UnsortedColumns updates = null;
        CQL3CasConditions conditions = null;
        LinkedHashSet<ColumnIdentifier> columnsWithConditions = new LinkedHashSet<ColumnIdentifier>();
        for (int i = 0; i < this.statements.size(); ++i) {
            ModificationStatement statement = this.statements.get(i);
            List<ByteBuffer> statementVariables = variables.getVariablesForStatement(i);
            long timestamp = this.attrs.getTimestamp(now, statementVariables);
            List<ByteBuffer> pks = statement.buildPartitionKeyNames(statementVariables);
            if (pks.size() > 1) {
                throw new IllegalArgumentException("Batch with conditions cannot span multiple partitions (you cannot use IN on the partition key)");
            }
            if (key == null) {
                key = pks.get(0);
                ksName = statement.cfm.ksName;
                cfName = statement.cfm.cfName;
                conditions = new CQL3CasConditions(statement.cfm, now);
                updates = UnsortedColumns.factory.create(statement.cfm);
            } else if (!key.equals(pks.get(0))) {
                throw new InvalidRequestException("Batch with conditions cannot span multiple partitions");
            }
            ColumnNameBuilder clusteringPrefix = statement.createClusteringPrefixBuilder(statementVariables);
            if (statement.hasConditions()) {
                statement.addUpdatesAndConditions(key, clusteringPrefix, updates, conditions, statementVariables, timestamp);
                if (statement.hasIfNotExistCondition() || statement.hasIfExistCondition()) {
                    columnsWithConditions = null;
                    continue;
                }
                if (columnsWithConditions == null) continue;
                Iterables.addAll(columnsWithConditions, statement.getColumnsWithConditions());
                continue;
            }
            UpdateParameters params = statement.makeUpdateParameters(Collections.singleton(key), clusteringPrefix, statementVariables, false, cl, now);
            statement.addUpdateForKey(updates, key, clusteringPrefix, params);
        }
        this.verifyBatchSize(Collections.singleton(updates));
        ColumnFamily result = StorageProxy.cas(ksName, cfName, key, conditions, updates, serialCf, cl);
        return new ResultMessage.Rows(ModificationStatement.buildCasResultSet(ksName, key, cfName, result, columnsWithConditions, true));
    }

    @Override
    public ResultMessage executeInternal(QueryState queryState, QueryOptions options) throws RequestValidationException, RequestExecutionException {
        assert (!this.hasConditions);
        for (IMutation iMutation : this.getMutations(new PreparedBatchVariables(options.getValues()), true, null, queryState.getTimestamp())) {
            iMutation.apply();
        }
        return null;
    }

    public String toString() {
        return String.format("BatchStatement(type=%s, statements=%s)", new Object[]{this.type, this.statements});
    }

    public static class Parsed
    extends CFStatement {
        private final Type type;
        private final Attributes.Raw attrs;
        private final List<ModificationStatement.Parsed> parsedStatements;

        public Parsed(Type type, Attributes.Raw attrs, List<ModificationStatement.Parsed> parsedStatements) {
            super(null);
            this.type = type;
            this.attrs = attrs;
            this.parsedStatements = parsedStatements;
        }

        @Override
        public void prepareKeyspace(ClientState state) throws InvalidRequestException {
            for (ModificationStatement.Parsed statement : this.parsedStatements) {
                statement.prepareKeyspace(state);
            }
        }

        @Override
        public ParsedStatement.Prepared prepare() throws InvalidRequestException {
            VariableSpecifications boundNames = this.getBoundVariables();
            ArrayList<ModificationStatement> statements = new ArrayList<ModificationStatement>(this.parsedStatements.size());
            boolean hasConditions = false;
            for (ModificationStatement.Parsed parsed : this.parsedStatements) {
                ModificationStatement stmt = parsed.prepare(boundNames);
                if (stmt.hasConditions()) {
                    hasConditions = true;
                }
                if (stmt.isCounter() && this.type != Type.COUNTER) {
                    throw new InvalidRequestException("Counter mutations are only allowed in COUNTER batches");
                }
                if (!stmt.isCounter() && this.type == Type.COUNTER) {
                    throw new InvalidRequestException("Only counter mutations are allowed in COUNTER batches");
                }
                statements.add(stmt);
            }
            if (hasConditions) {
                String ksName = null;
                String cfName = null;
                for (ModificationStatement stmt : statements) {
                    if (!(ksName == null || stmt.keyspace().equals(ksName) && stmt.columnFamily().equals(cfName))) {
                        throw new InvalidRequestException("Batch with conditions cannot span multiple tables");
                    }
                    ksName = stmt.keyspace();
                    cfName = stmt.columnFamily();
                }
            }
            Attributes prepAttrs = this.attrs.prepare("[batch]", "[batch]");
            prepAttrs.collectMarkerSpecification(boundNames);
            return new ParsedStatement.Prepared((CQLStatement)new BatchStatement(boundNames.size(), this.type, statements, prepAttrs, hasConditions), boundNames);
        }
    }

    public static class BatchOfPreparedVariables
    implements BatchVariables {
        private final List<List<ByteBuffer>> variables;

        public BatchOfPreparedVariables(List<List<ByteBuffer>> variables) {
            this.variables = variables;
        }

        @Override
        public List<ByteBuffer> getVariablesForStatement(int statementInBatch) {
            return this.variables.get(statementInBatch);
        }
    }

    public static class PreparedBatchVariables
    implements BatchVariables {
        private final List<ByteBuffer> variables;

        public PreparedBatchVariables(List<ByteBuffer> variables) {
            this.variables = variables;
        }

        @Override
        public List<ByteBuffer> getVariablesForStatement(int statementInBatch) {
            return this.variables;
        }
    }

    public static interface BatchVariables {
        public List<ByteBuffer> getVariablesForStatement(int var1);
    }

    public static enum Type {
        LOGGED,
        UNLOGGED,
        COUNTER;

    }
}

