/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements;

import com.google.common.base.Objects;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Column;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.CompositeType;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.Pair;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ColumnGroupMap {
    public static ColumnGroupMap EMPTY = new ColumnGroupMap(null, false);
    private final ByteBuffer[] fullPath;
    private final Map<ByteBuffer, Value> map = new HashMap<ByteBuffer, Value>();
    public final boolean isStatic;

    private ColumnGroupMap(ByteBuffer[] fullPath, boolean isStatic) {
        this.fullPath = fullPath;
        this.isStatic = isStatic;
    }

    private void add(ByteBuffer[] fullName, int idx, Column column) {
        ByteBuffer columnName = fullName[idx];
        if (fullName.length == idx + 2) {
            Value v = this.map.get(columnName);
            if (v == null) {
                v = new Collection();
                this.map.put(columnName, v);
            }
            assert (v instanceof Collection);
            ((Collection)v).add(Pair.create(fullName[idx + 1], column));
        } else {
            assert (!this.map.containsKey(columnName));
            this.map.put(columnName, new Simple(column));
        }
    }

    public ByteBuffer getKeyComponent(int pos) {
        return this.fullPath == null ? null : this.fullPath[pos];
    }

    public Column getSimple(ByteBuffer key) {
        Value v = this.map.get(key);
        if (v == null) {
            return null;
        }
        assert (v instanceof Simple);
        return ((Simple)v).column;
    }

    public List<Pair<ByteBuffer, Column>> getCollection(ByteBuffer key) {
        Value v = this.map.get(key);
        if (v == null) {
            return null;
        }
        assert (v instanceof Collection);
        return (List)((Object)v);
    }

    public boolean hasValueFor(ByteBuffer key) {
        return this.map.containsKey(key);
    }

    public String toString() {
        ArrayList<String> fullStringPath = new ArrayList<String>(this.fullPath.length);
        for (ByteBuffer buffer : this.fullPath) {
            fullStringPath.add(ByteBufferUtil.bytesToHex(buffer));
        }
        ArrayList<String> stringMap = new ArrayList<String>(this.fullPath.length);
        for (Map.Entry<ByteBuffer, Value> entry : this.map.entrySet()) {
            stringMap.add(ByteBufferUtil.bytesToHex(entry.getKey()) + ": " + entry.getValue());
        }
        return Objects.toStringHelper((Object)this).add("fullPath", (Object)("[" + StringUtils.join(fullStringPath, (String)", ") + "]")).add("map", (Object)("{" + StringUtils.join(stringMap, (String)", ") + "}")).add("isStatic", this.isStatic).toString();
    }

    public static class Builder {
        private final CompositeType composite;
        private final int idx;
        private final long now;
        private ByteBuffer[] previous;
        private final List<ColumnGroupMap> groups = new ArrayList<ColumnGroupMap>();
        private ColumnGroupMap currentGroup;

        public Builder(CompositeType composite, boolean hasCollections, long now) {
            this.composite = composite;
            this.idx = composite.types.size() - (hasCollections ? 2 : 1);
            this.now = now;
        }

        public void add(Column c) {
            if (c.isMarkedForDelete(this.now)) {
                return;
            }
            ByteBuffer[] current = this.composite.split(c.name());
            if (this.currentGroup == null) {
                this.currentGroup = new ColumnGroupMap(current, CompositeType.isStaticName(c.name()));
                this.currentGroup.add(current, this.idx, c);
                this.previous = current;
                return;
            }
            if (this.currentGroup.isStatic && !CompositeType.isStaticName(c.name()) || !this.isSameGroup(current)) {
                this.groups.add(this.currentGroup);
                this.currentGroup = new ColumnGroupMap(current, false);
            }
            this.currentGroup.add(current, this.idx, c);
            this.previous = current;
        }

        private boolean isSameGroup(ByteBuffer[] c) {
            for (int i = 0; i < this.idx; ++i) {
                AbstractType<?> comp = this.composite.types.get(i);
                if (comp.compare(c[i], this.previous[i]) == 0) continue;
                return false;
            }
            return true;
        }

        public List<ColumnGroupMap> groups() {
            if (this.currentGroup != null) {
                this.groups.add(this.currentGroup);
                this.currentGroup = null;
            }
            return this.groups;
        }

        public boolean isEmpty() {
            return this.currentGroup == null && this.groups.isEmpty();
        }

        public ColumnGroupMap firstGroup() {
            if (this.currentGroup != null) {
                this.groups.add(this.currentGroup);
                this.currentGroup = null;
            }
            return this.groups.get(0);
        }

        public void discardFirst() {
            this.groups.remove(0);
        }
    }

    private static class Collection
    extends ArrayList<Pair<ByteBuffer, Column>>
    implements Value {
        private Collection() {
        }
    }

    private static class Simple
    implements Value {
        public final Column column;

        Simple(Column column) {
            this.column = column;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("column", (Object)ByteBufferUtil.bytesToHex(this.column.name())).toString();
        }
    }

    private static interface Value {
    }
}

