/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements;

import com.netflix.astyanax.shaded.org.apache.cassandra.config.CFMetaData;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.Schema;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.TriggerDefinition;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.CFName;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.ConfigurationException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.RequestValidationException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.UnauthorizedException;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.ClientState;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.MigrationManager;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.ThriftValidation;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.ResultMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.triggers.TriggerExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTriggerStatement
extends SchemaAlteringStatement {
    private static final Logger logger = LoggerFactory.getLogger(CreateTriggerStatement.class);
    private final String triggerName;
    private final String triggerClass;

    public CreateTriggerStatement(CFName name, String triggerName, String clazz) {
        super(name);
        this.triggerName = triggerName;
        this.triggerClass = clazz;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException {
        state.ensureIsSuper("Only superusers are allowed to perform CREATE TRIGGER queries");
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
        try {
            TriggerExecutor.instance.loadTriggerInstance(this.triggerClass);
        }
        catch (Exception e) {
            throw new ConfigurationException(String.format("Trigger class '%s' doesn't exist", this.triggerClass));
        }
    }

    @Override
    public boolean announceMigration() throws ConfigurationException {
        CFMetaData cfm = Schema.instance.getCFMetaData(this.keyspace(), this.columnFamily()).clone();
        cfm.addTriggerDefinition(TriggerDefinition.create(this.triggerName, this.triggerClass));
        logger.info("Adding trigger with name {} and class {}", (Object)this.triggerName, (Object)this.triggerClass);
        MigrationManager.announceColumnFamilyUpdate(cfm, false);
        return true;
    }

    @Override
    public ResultMessage.SchemaChange.Change changeType() {
        return ResultMessage.SchemaChange.Change.UPDATED;
    }
}

