/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements;

import com.netflix.astyanax.shaded.org.apache.cassandra.auth.Permission;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.CFName;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.CQLStatement;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.QueryOptions;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.CFStatement;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.ParsedStatement;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.InvalidRequestException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.TruncateException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.UnauthorizedException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.UnavailableException;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.ClientState;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.QueryState;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.StorageProxy;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.ThriftValidation;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.ResultMessage;
import java.io.IOException;
import java.util.concurrent.TimeoutException;

public class TruncateStatement
extends CFStatement
implements CQLStatement {
    public TruncateStatement(CFName name) {
        super(name);
    }

    @Override
    public int getBoundTerms() {
        return 0;
    }

    @Override
    public ParsedStatement.Prepared prepare() throws InvalidRequestException {
        return new ParsedStatement.Prepared(this);
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException, UnauthorizedException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.MODIFY);
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
        ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
    }

    @Override
    public ResultMessage execute(QueryState state, QueryOptions options) throws InvalidRequestException, TruncateException {
        try {
            StorageProxy.truncateBlocking(this.keyspace(), this.columnFamily());
        }
        catch (UnavailableException e) {
            throw new TruncateException(e);
        }
        catch (TimeoutException e) {
            throw new TruncateException(e);
        }
        catch (IOException e) {
            throw new TruncateException(e);
        }
        return null;
    }

    @Override
    public ResultMessage executeInternal(QueryState state, QueryOptions options) {
        throw new UnsupportedOperationException();
    }
}

