/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db;

import com.netflix.astyanax.shaded.org.apache.cassandra.config.DatabaseDescriptor;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.CounterMutation;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.WriteResponse;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.RequestExecutionException;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.IVerbHandler;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessageIn;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessagingService;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.StorageProxy;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CounterMutationVerbHandler
implements IVerbHandler<CounterMutation> {
    private static final Logger logger = LoggerFactory.getLogger(CounterMutationVerbHandler.class);

    @Override
    public void doVerb(final MessageIn<CounterMutation> message, final int id) {
        try {
            CounterMutation cm = (CounterMutation)message.payload;
            if (logger.isDebugEnabled()) {
                logger.debug("Applying forwarded " + cm);
            }
            String localDataCenter = DatabaseDescriptor.getEndpointSnitch().getDatacenter(FBUtilities.getBroadcastAddress());
            StorageProxy.applyCounterMutationOnLeader(cm, localDataCenter, new Runnable(){

                @Override
                public void run() {
                    WriteResponse response = new WriteResponse();
                    MessagingService.instance().sendReply(response.createMessage(), id, message.from);
                }
            });
        }
        catch (RequestExecutionException e) {
            logger.debug("counter error", (Throwable)e);
        }
    }
}

