/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db;

import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Column;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.DeletionTime;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.RangeTombstone;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.RangeTombstoneList;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.TypeSizes;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.IVersionedSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Iterator;

public class DeletionInfo {
    private static final Serializer serializer = new Serializer();
    private DeletionTime topLevel;
    private RangeTombstoneList ranges;

    public DeletionInfo(long markedForDeleteAt, int localDeletionTime) {
        this(new DeletionTime(markedForDeleteAt, localDeletionTime == Integer.MIN_VALUE ? Integer.MAX_VALUE : localDeletionTime));
    }

    public DeletionInfo(DeletionTime topLevel) {
        this(topLevel, null);
    }

    public DeletionInfo(ByteBuffer start, ByteBuffer end, Comparator<ByteBuffer> comparator, long markedForDeleteAt, int localDeletionTime) {
        this(DeletionTime.LIVE, new RangeTombstoneList(comparator, 1));
        this.ranges.add(start, end, markedForDeleteAt, localDeletionTime);
    }

    public DeletionInfo(RangeTombstone rangeTombstone, Comparator<ByteBuffer> comparator) {
        this((ByteBuffer)rangeTombstone.min, (ByteBuffer)rangeTombstone.max, comparator, ((DeletionTime)rangeTombstone.data).markedForDeleteAt, ((DeletionTime)rangeTombstone.data).localDeletionTime);
    }

    private DeletionInfo(DeletionTime topLevel, RangeTombstoneList ranges) {
        this.topLevel = topLevel;
        this.ranges = ranges;
    }

    public static DeletionInfo live() {
        return new DeletionInfo(DeletionTime.LIVE);
    }

    public static Serializer serializer() {
        return serializer;
    }

    public DeletionInfo copy() {
        return new DeletionInfo(this.topLevel, this.ranges == null ? null : this.ranges.copy());
    }

    public boolean isLive() {
        return this.topLevel.markedForDeleteAt == Long.MIN_VALUE && this.topLevel.localDeletionTime == Integer.MAX_VALUE && (this.ranges == null || this.ranges.isEmpty());
    }

    public boolean isDeleted(Column column) {
        return this.isDeleted(column.name(), column.timestamp());
    }

    public boolean isDeleted(ByteBuffer name, long timestamp) {
        if (this.isLive()) {
            return false;
        }
        if (timestamp <= this.topLevel.markedForDeleteAt) {
            return true;
        }
        return this.ranges != null && this.ranges.isDeleted(name, timestamp);
    }

    InOrderTester inOrderTester() {
        return this.inOrderTester(false);
    }

    public InOrderTester inOrderTester(boolean reversed) {
        return new InOrderTester(reversed);
    }

    public void purge(int gcBefore) {
        DeletionTime deletionTime = this.topLevel = this.topLevel.localDeletionTime < gcBefore ? DeletionTime.LIVE : this.topLevel;
        if (this.ranges != null) {
            this.ranges.purge(gcBefore);
            if (this.ranges.isEmpty()) {
                this.ranges = null;
            }
        }
    }

    public DeletionInfo diff(DeletionInfo superset) {
        RangeTombstoneList rangeDiff = superset.ranges == null || superset.ranges.isEmpty() ? null : (this.ranges == null ? superset.ranges : this.ranges.diff(superset.ranges));
        return this.topLevel.markedForDeleteAt != superset.topLevel.markedForDeleteAt || rangeDiff != null ? new DeletionInfo(superset.topLevel, rangeDiff) : DeletionInfo.live();
    }

    public boolean hasPurgeableTombstones(int gcBefore) {
        if (this.topLevel.localDeletionTime < gcBefore) {
            return true;
        }
        return this.ranges != null && this.ranges.hasPurgeableTombstones(gcBefore);
    }

    public void add(DeletionTime newInfo) {
        if (this.topLevel.markedForDeleteAt < newInfo.markedForDeleteAt) {
            this.topLevel = newInfo;
        }
    }

    public void add(RangeTombstone tombstone, Comparator<ByteBuffer> comparator) {
        if (this.ranges == null) {
            this.ranges = new RangeTombstoneList(comparator, 1);
        }
        this.ranges.add(tombstone);
    }

    public DeletionInfo add(DeletionInfo newInfo) {
        this.add(newInfo.topLevel);
        if (this.ranges == null) {
            this.ranges = newInfo.ranges == null ? null : newInfo.ranges.copy();
        } else if (newInfo.ranges != null) {
            this.ranges.addAll(newInfo.ranges);
        }
        return this;
    }

    public long minTimestamp() {
        return this.ranges == null ? this.topLevel.markedForDeleteAt : Math.min(this.topLevel.markedForDeleteAt, this.ranges.minMarkedAt());
    }

    public long maxTimestamp() {
        return this.ranges == null ? this.topLevel.markedForDeleteAt : Math.max(this.topLevel.markedForDeleteAt, this.ranges.maxMarkedAt());
    }

    public DeletionTime getTopLevelDeletion() {
        return this.topLevel;
    }

    public Iterator<RangeTombstone> rangeIterator() {
        return this.ranges == null ? Iterators.emptyIterator() : this.ranges.iterator();
    }

    public DeletionTime rangeCovering(ByteBuffer name) {
        return this.ranges == null ? null : this.ranges.search(name);
    }

    public int dataSize() {
        int size = TypeSizes.NATIVE.sizeof(this.topLevel.markedForDeleteAt);
        return size + (this.ranges == null ? 0 : this.ranges.dataSize());
    }

    public boolean hasRanges() {
        return this.ranges != null && !this.ranges.isEmpty();
    }

    public int rangeCount() {
        return this.hasRanges() ? this.ranges.size() : 0;
    }

    public boolean mayModify(DeletionInfo delInfo) {
        return this.topLevel.markedForDeleteAt > delInfo.topLevel.markedForDeleteAt || this.hasRanges();
    }

    public String toString() {
        if (this.ranges == null || this.ranges.isEmpty()) {
            return String.format("{%s}", this.topLevel);
        }
        return String.format("{%s, ranges=%s}", this.topLevel, this.rangesAsString());
    }

    private String rangesAsString() {
        assert (!this.ranges.isEmpty());
        StringBuilder sb = new StringBuilder();
        AbstractType at = (AbstractType)this.ranges.comparator();
        assert (at != null);
        Iterator<RangeTombstone> iter = this.rangeIterator();
        while (iter.hasNext()) {
            RangeTombstone i = iter.next();
            sb.append("[");
            sb.append(at.getString((ByteBuffer)i.min)).append("-");
            sb.append(at.getString((ByteBuffer)i.max)).append(", ");
            sb.append(i.data);
            sb.append("]");
        }
        return sb.toString();
    }

    public void updateAllTimestamp(long timestamp) {
        if (this.topLevel.markedForDeleteAt != Long.MIN_VALUE) {
            this.topLevel = new DeletionTime(timestamp, this.topLevel.localDeletionTime);
        }
        if (this.ranges != null) {
            this.ranges.updateAllTimestamp(timestamp);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof DeletionInfo)) {
            return false;
        }
        DeletionInfo that = (DeletionInfo)o;
        return this.topLevel.equals(that.topLevel) && Objects.equal((Object)this.ranges, (Object)that.ranges);
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.topLevel, this.ranges});
    }

    public class InOrderTester {
        private RangeTombstoneList.InOrderTester tester;
        private final boolean reversed;

        private InOrderTester(boolean reversed) {
            this.reversed = reversed;
        }

        public boolean isDeleted(Column column) {
            return this.isDeleted(column.name(), column.timestamp());
        }

        public boolean isDeleted(ByteBuffer name, long timestamp) {
            if (timestamp <= ((DeletionInfo)DeletionInfo.this).topLevel.markedForDeleteAt) {
                return true;
            }
            if (this.reversed) {
                return DeletionInfo.this.isDeleted(name, timestamp);
            }
            if (this.tester == null && DeletionInfo.this.ranges != null) {
                this.tester = DeletionInfo.this.ranges.inOrderTester();
            }
            return this.tester != null && this.tester.isDeleted(name, timestamp);
        }
    }

    public static class Serializer
    implements IVersionedSerializer<DeletionInfo> {
        @Override
        public void serialize(DeletionInfo info, DataOutput out, int version) throws IOException {
            DeletionTime.serializer.serialize(info.topLevel, out);
            RangeTombstoneList.serializer.serialize(info.ranges, out, version);
        }

        @Override
        public DeletionInfo deserialize(DataInput in, int version) throws IOException {
            throw new UnsupportedOperationException();
        }

        public DeletionInfo deserialize(DataInput in, int version, Comparator<ByteBuffer> comparator) throws IOException {
            DeletionTime topLevel = DeletionTime.serializer.deserialize(in);
            RangeTombstoneList ranges = RangeTombstoneList.serializer.deserialize(in, version, comparator);
            return new DeletionInfo(topLevel, ranges);
        }

        public long serializedSize(DeletionInfo info, TypeSizes typeSizes, int version) {
            long size = DeletionTime.serializer.serializedSize(info.topLevel, typeSizes);
            return size + RangeTombstoneList.serializer.serializedSize(info.ranges, typeSizes, version);
        }

        @Override
        public long serializedSize(DeletionInfo info, int version) {
            return this.serializedSize(info, TypeSizes.NATIVE, version);
        }
    }
}

