/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db;

import com.netflix.astyanax.shaded.org.apache.cassandra.config.CFMetaData;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Column;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.DeletionTime;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.OnDiskAtom;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.TypeSizes;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.ISSTableSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.sstable.Descriptor;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.DataOutputBuffer;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.MarshalException;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.Interval;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class RangeTombstone
extends Interval<ByteBuffer, DeletionTime>
implements OnDiskAtom {
    public static final Serializer serializer = new Serializer();

    public RangeTombstone(ByteBuffer start, ByteBuffer stop, long markedForDeleteAt, int localDeletionTime) {
        this(start, stop, new DeletionTime(markedForDeleteAt, localDeletionTime));
    }

    public RangeTombstone(ByteBuffer start, ByteBuffer stop, DeletionTime delTime) {
        super(start, stop, delTime);
    }

    @Override
    public ByteBuffer name() {
        return (ByteBuffer)this.min;
    }

    @Override
    public int getLocalDeletionTime() {
        return ((DeletionTime)this.data).localDeletionTime;
    }

    @Override
    public long minTimestamp() {
        return ((DeletionTime)this.data).markedForDeleteAt;
    }

    @Override
    public long maxTimestamp() {
        return ((DeletionTime)this.data).markedForDeleteAt;
    }

    @Override
    public int serializedSize(TypeSizes typeSizes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long serializedSizeForSSTable() {
        TypeSizes typeSizes = TypeSizes.NATIVE;
        return (long)(typeSizes.sizeof((short)((ByteBuffer)this.min).remaining()) + ((ByteBuffer)this.min).remaining() + 1 + typeSizes.sizeof((short)((ByteBuffer)this.max).remaining()) + ((ByteBuffer)this.max).remaining()) + DeletionTime.serializer.serializedSize((DeletionTime)this.data, typeSizes);
    }

    @Override
    public void validateFields(CFMetaData metadata) throws MarshalException {
        metadata.comparator.validate((ByteBuffer)this.min);
        metadata.comparator.validate((ByteBuffer)this.max);
    }

    @Override
    public void updateDigest(MessageDigest digest) {
        digest.update(((ByteBuffer)this.min).duplicate());
        digest.update(((ByteBuffer)this.max).duplicate());
        DataOutputBuffer buffer = new DataOutputBuffer();
        try {
            buffer.writeLong(((DeletionTime)this.data).markedForDeleteAt);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        digest.update(buffer.getData(), 0, buffer.getLength());
    }

    public boolean supersedes(RangeTombstone rt, Comparator<ByteBuffer> comparator) {
        if (((DeletionTime)rt.data).markedForDeleteAt > ((DeletionTime)this.data).markedForDeleteAt) {
            return false;
        }
        return comparator.compare((ByteBuffer)this.min, (ByteBuffer)rt.min) <= 0 && comparator.compare((ByteBuffer)this.max, (ByteBuffer)rt.max) >= 0;
    }

    public static class Serializer
    implements ISSTableSerializer<RangeTombstone> {
        @Override
        public void serializeForSSTable(RangeTombstone t, DataOutput out) throws IOException {
            ByteBufferUtil.writeWithShortLength((ByteBuffer)t.min, out);
            out.writeByte(16);
            ByteBufferUtil.writeWithShortLength((ByteBuffer)t.max, out);
            DeletionTime.serializer.serialize((DeletionTime)t.data, out);
        }

        @Override
        public RangeTombstone deserializeFromSSTable(DataInput in, Descriptor.Version version) throws IOException {
            ByteBuffer min = ByteBufferUtil.readWithShortLength(in);
            if (min.remaining() <= 0) {
                throw ColumnSerializer.CorruptColumnException.create(in, min);
            }
            int b = in.readUnsignedByte();
            assert ((b & 0x10) != 0);
            return this.deserializeBody(in, min, version);
        }

        public RangeTombstone deserializeBody(DataInput in, ByteBuffer min, Descriptor.Version version) throws IOException {
            ByteBuffer max = ByteBufferUtil.readWithShortLength(in);
            if (max.remaining() <= 0) {
                throw ColumnSerializer.CorruptColumnException.create(in, max);
            }
            DeletionTime dt = DeletionTime.serializer.deserialize(in);
            return new RangeTombstone(min, max, dt);
        }
    }

    public static class Tracker {
        private final Comparator<ByteBuffer> comparator;
        private final List<RangeTombstone> openedTombstones = new LinkedList<RangeTombstone>();
        private int atomCount;

        public Tracker(Comparator<ByteBuffer> comparator) {
            this.comparator = comparator;
        }

        public long writeOpenedMarker(OnDiskAtom firstColumn, DataOutput out, OnDiskAtom.Serializer atomSerializer) throws IOException {
            long size = 0L;
            if (this.openedTombstones.isEmpty()) {
                return size;
            }
            LinkedList<RangeTombstone> toWrite = new LinkedList<RangeTombstone>();
            block0: for (RangeTombstone tombstone : this.openedTombstones) {
                if (this.comparator.compare(firstColumn.name(), (ByteBuffer)tombstone.max) > 0 || tombstone instanceof ExpiredRangeTombstone) continue;
                RangeTombstone updated = new RangeTombstone(firstColumn.name(), (ByteBuffer)tombstone.max, (DeletionTime)tombstone.data);
                Iterator iter = toWrite.iterator();
                while (iter.hasNext()) {
                    RangeTombstone other = (RangeTombstone)iter.next();
                    if (other.supersedes(updated, this.comparator)) break block0;
                    if (!updated.supersedes(other, this.comparator)) continue;
                    iter.remove();
                }
                toWrite.add(tombstone);
            }
            for (RangeTombstone tombstone : toWrite) {
                size += tombstone.serializedSizeForSSTable();
                ++this.atomCount;
                if (out == null) continue;
                atomSerializer.serializeForSSTable(tombstone, out);
            }
            return size;
        }

        public int writtenAtom() {
            return this.atomCount;
        }

        public void update(OnDiskAtom atom, boolean isExpired) {
            ListIterator<RangeTombstone> iterator = this.openedTombstones.listIterator();
            while (iterator.hasNext()) {
                RangeTombstone t = iterator.next();
                if (this.comparator.compare(atom.name(), (ByteBuffer)t.max) > 0) {
                    iterator.remove();
                    continue;
                }
                iterator.previous();
                break;
            }
            if (atom instanceof RangeTombstone) {
                RangeTombstone toAdd = (RangeTombstone)atom;
                if (isExpired) {
                    toAdd = new ExpiredRangeTombstone(toAdd);
                }
                while (iterator.hasNext()) {
                    RangeTombstone existing = iterator.next();
                    int cmp = this.comparator.compare((ByteBuffer)toAdd.max, (ByteBuffer)existing.max);
                    if (cmp > 0) {
                        if (!((DeletionTime)toAdd.data).supersedes((DeletionTime)existing.data)) continue;
                        iterator.remove();
                        continue;
                    }
                    if (((DeletionTime)toAdd.data).supersedes((DeletionTime)existing.data)) {
                        if (cmp == 0) {
                            iterator.set(toAdd);
                        } else {
                            Tracker.insertBefore(toAdd, iterator);
                        }
                    }
                    return;
                }
                iterator.add(toAdd);
            }
        }

        private static void insertBefore(RangeTombstone tombstone, ListIterator<RangeTombstone> iterator) {
            assert (iterator.hasPrevious());
            iterator.previous();
            iterator.add(tombstone);
            iterator.next();
        }

        public boolean isDeleted(Column column) {
            for (RangeTombstone tombstone : this.openedTombstones) {
                if (this.comparator.compare(column.name(), (ByteBuffer)tombstone.max) > 0 || tombstone.maxTimestamp() < column.timestamp()) continue;
                return true;
            }
            return false;
        }

        private static class ExpiredRangeTombstone
        extends RangeTombstone {
            private ExpiredRangeTombstone(RangeTombstone tombstone) {
                super((ByteBuffer)tombstone.min, (ByteBuffer)tombstone.max, (DeletionTime)tombstone.data);
            }
        }
    }
}

