/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.DecoratedKey;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.TypeSizes;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.IPartitioner;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.RingPosition;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.Token;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.ISerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.StorageService;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class RowPosition
implements RingPosition<RowPosition> {
    public static final RowPositionSerializer serializer = new RowPositionSerializer();

    public static RowPosition forKey(ByteBuffer key, IPartitioner p) {
        return key == null || key.remaining() == 0 ? ((Token)p.getMinimumToken()).minKeyBound() : p.decorateKey(key);
    }

    @Override
    public abstract Token getToken();

    public abstract Kind kind();

    public boolean isMinimum() {
        return this.isMinimum(StorageService.getPartitioner());
    }

    public static class RowPositionSerializer
    implements ISerializer<RowPosition> {
        @Override
        public void serialize(RowPosition pos, DataOutput out) throws IOException {
            Kind kind = pos.kind();
            out.writeByte(kind.ordinal());
            if (kind == Kind.ROW_KEY) {
                ByteBufferUtil.writeWithShortLength(((DecoratedKey)pos).key, out);
            } else {
                Token.serializer.serialize(pos.getToken(), out);
            }
        }

        @Override
        public RowPosition deserialize(DataInput in) throws IOException {
            Kind kind = Kind.fromOrdinal(in.readByte());
            if (kind == Kind.ROW_KEY) {
                ByteBuffer k = ByteBufferUtil.readWithShortLength(in);
                return StorageService.getPartitioner().decorateKey(k);
            }
            Token t = Token.serializer.deserialize(in);
            return kind == Kind.MIN_BOUND ? t.minKeyBound() : t.maxKeyBound();
        }

        @Override
        public long serializedSize(RowPosition pos, TypeSizes typeSizes) {
            Kind kind = pos.kind();
            int size = 1;
            if (kind == Kind.ROW_KEY) {
                int keySize = ((DecoratedKey)pos).key.remaining();
                size += typeSizes.sizeof((short)keySize) + keySize;
            } else {
                size = (int)((long)size + Token.serializer.serializedSize(pos.getToken(), typeSizes));
            }
            return size;
        }
    }

    public static enum Kind {
        ROW_KEY,
        MIN_BOUND,
        MAX_BOUND;

        private static final Kind[] allKinds;

        static Kind fromOrdinal(int ordinal) {
            return allKinds[ordinal];
        }

        static {
            allKinds = Kind.values();
        }
    }
}

