/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db.compaction;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamilyStore;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Directories;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.compaction.CompactionManager;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.compaction.OperationType;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.sstable.SSTableReader;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.DiskAwareRunnable;
import java.util.Set;

public abstract class AbstractCompactionTask
extends DiskAwareRunnable {
    protected final ColumnFamilyStore cfs;
    protected Iterable<SSTableReader> sstables;
    protected boolean isUserDefined;
    protected OperationType compactionType;

    public AbstractCompactionTask(ColumnFamilyStore cfs, Iterable<SSTableReader> sstables) {
        this.cfs = cfs;
        this.sstables = sstables;
        this.isUserDefined = false;
        this.compactionType = OperationType.COMPACTION;
        Set<SSTableReader> compacting = cfs.getDataTracker().getCompacting();
        for (SSTableReader sstable : sstables) {
            assert (compacting.contains(sstable)) : sstable.getFilename() + " is not correctly marked compacting";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(CompactionManager.CompactionExecutorStatsCollector collector) {
        try {
            int n = this.executeInternal(collector);
            return n;
        }
        finally {
            this.cfs.getDataTracker().unmarkCompacting(this.sstables);
        }
    }

    protected abstract int executeInternal(CompactionManager.CompactionExecutorStatsCollector var1);

    @Override
    protected Directories getDirectories() {
        return this.cfs.directories;
    }

    public AbstractCompactionTask setUserDefined(boolean isUserDefined) {
        this.isUserDefined = isUserDefined;
        return this;
    }

    public AbstractCompactionTask setCompactionType(OperationType compactionType) {
        this.compactionType = compactionType;
        return this;
    }

    public String toString() {
        return "CompactionTask(" + this.sstables + ")";
    }
}

