/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db.index;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamilyStore;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.DecoratedKey;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Keyspace;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.compaction.CompactionInfo;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.compaction.CompactionInterruptedException;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.compaction.OperationType;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.sstable.ReducingKeyIterator;
import java.io.IOException;
import java.util.Set;

public class SecondaryIndexBuilder
extends CompactionInfo.Holder {
    private final ColumnFamilyStore cfs;
    private final Set<String> idxNames;
    private final ReducingKeyIterator iter;

    public SecondaryIndexBuilder(ColumnFamilyStore cfs, Set<String> idxNames, ReducingKeyIterator iter) {
        this.cfs = cfs;
        this.idxNames = idxNames;
        this.iter = iter;
    }

    @Override
    public CompactionInfo getCompactionInfo() {
        return new CompactionInfo(this.cfs.metadata, OperationType.INDEX_BUILD, this.iter.getBytesRead(), this.iter.getTotalBytes());
    }

    public void build() {
        while (this.iter.hasNext()) {
            if (this.isStopRequested()) {
                throw new CompactionInterruptedException(this.getCompactionInfo());
            }
            DecoratedKey key = this.iter.next();
            Keyspace.indexRow(key, this.cfs, this.idxNames);
        }
        try {
            this.iter.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

