/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db.index.composites;

import com.netflix.astyanax.shaded.org.apache.cassandra.config.CFMetaData;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.ColumnDefinition;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.ColumnNameBuilder;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ArrayBackedSortedColumns;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Column;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamily;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.DecoratedKey;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.index.AbstractSimplePerColumnSecondaryIndex;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.index.SecondaryIndexManager;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.index.SecondaryIndexSearcher;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.index.composites.CompositesIndexOnClusteringKey;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.index.composites.CompositesIndexOnPartitionKey;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.index.composites.CompositesIndexOnRegular;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.index.composites.CompositesSearcher;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.CompositeType;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.ConfigurationException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Set;

public abstract class CompositesIndex
extends AbstractSimplePerColumnSecondaryIndex {
    private volatile CompositeType indexComparator;

    protected CompositeType getIndexComparator() {
        if (this.indexComparator == null) {
            assert (this.columnDef != null);
            this.indexComparator = CompositesIndex.getIndexComparator(this.baseCfs.metadata, this.columnDef);
        }
        return this.indexComparator;
    }

    public static CompositesIndex create(ColumnDefinition cfDef) {
        switch (cfDef.type) {
            case CLUSTERING_KEY: {
                return new CompositesIndexOnClusteringKey();
            }
            case REGULAR: {
                return new CompositesIndexOnRegular();
            }
            case PARTITION_KEY: {
                return new CompositesIndexOnPartitionKey();
            }
        }
        throw new AssertionError();
    }

    public static CompositeType getIndexComparator(CFMetaData baseMetadata, ColumnDefinition cfDef) {
        switch (cfDef.type) {
            case CLUSTERING_KEY: {
                return CompositesIndexOnClusteringKey.buildIndexComparator(baseMetadata, cfDef);
            }
            case REGULAR: {
                return CompositesIndexOnRegular.buildIndexComparator(baseMetadata, cfDef);
            }
            case PARTITION_KEY: {
                return CompositesIndexOnPartitionKey.buildIndexComparator(baseMetadata, cfDef);
            }
        }
        throw new AssertionError();
    }

    @Override
    protected ByteBuffer makeIndexColumnName(ByteBuffer rowKey, Column column) {
        return this.makeIndexColumnNameBuilder(rowKey, column.name()).build();
    }

    protected abstract ColumnNameBuilder makeIndexColumnNameBuilder(ByteBuffer var1, ByteBuffer var2);

    public abstract IndexedEntry decodeEntry(DecoratedKey var1, Column var2);

    public abstract boolean isStale(IndexedEntry var1, ColumnFamily var2, long var3);

    public void delete(IndexedEntry entry) {
        int localDeletionTime = (int)(System.currentTimeMillis() / 1000L);
        ArrayBackedSortedColumns cfi = ArrayBackedSortedColumns.factory.create(this.indexCfs.metadata);
        cfi.addTombstone(entry.indexEntry, localDeletionTime, entry.timestamp);
        this.indexCfs.apply(entry.indexValue, cfi, SecondaryIndexManager.nullUpdater);
        if (logger.isDebugEnabled()) {
            logger.debug("removed index entry for cleaned-up value {}:{}", (Object)entry.indexValue, (Object)cfi);
        }
    }

    @Override
    protected AbstractType getExpressionComparator() {
        return this.baseCfs.metadata.getColumnDefinitionComparator(this.columnDef);
    }

    protected CompositeType getBaseComparator() {
        assert (this.baseCfs.getComparator() instanceof CompositeType);
        return (CompositeType)this.baseCfs.getComparator();
    }

    @Override
    public SecondaryIndexSearcher createSecondaryIndexSearcher(Set<ByteBuffer> columns) {
        return new CompositesSearcher(this.baseCfs.indexManager, columns);
    }

    @Override
    public void validateOptions() throws ConfigurationException {
        ColumnDefinition columnDef = (ColumnDefinition)this.columnDefs.iterator().next();
        HashMap<String, String> options = new HashMap<String, String>(columnDef.getIndexOptions());
        options.remove("prefix_size");
        if (!options.isEmpty()) {
            throw new ConfigurationException("Unknown options provided for COMPOSITES index: " + options.keySet());
        }
    }

    public static class IndexedEntry {
        public final DecoratedKey indexValue;
        public final ByteBuffer indexEntry;
        public final long timestamp;
        public final ByteBuffer indexedKey;
        public final ColumnNameBuilder indexedEntryNameBuilder;

        public IndexedEntry(DecoratedKey indexValue, ByteBuffer indexEntry, long timestamp, ByteBuffer indexedKey, ColumnNameBuilder indexedEntryNameBuilder) {
            this.indexValue = indexValue;
            this.indexEntry = indexEntry;
            this.timestamp = timestamp;
            this.indexedKey = indexedKey;
            this.indexedEntryNameBuilder = indexedEntryNameBuilder;
        }

        public ByteBuffer indexedEntryStart() {
            return this.indexedEntryNameBuilder.build();
        }

        public ByteBuffer indexedEntryEnd() {
            return this.indexedEntryNameBuilder.buildAsEndOfRange();
        }
    }
}

