/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal;

import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.CFDefinition;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Column;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.CollectionType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.EmptyType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.ListType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.TypeParser;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.ConfigurationException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.SyntaxException;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.SetSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.TypeSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.Pair;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SetType<T>
extends CollectionType<Set<T>> {
    private static final Map<AbstractType<?>, SetType> instances = new HashMap();
    public final AbstractType<T> elements;
    private final SetSerializer<T> serializer;

    public static SetType<?> getInstance(TypeParser parser) throws ConfigurationException, SyntaxException {
        List<AbstractType<?>> l = parser.getTypeParameters();
        if (l.size() != 1) {
            throw new ConfigurationException("SetType takes exactly 1 type parameter");
        }
        return SetType.getInstance(l.get(0));
    }

    public static synchronized <T> SetType<T> getInstance(AbstractType<T> elements) {
        SetType<T> t = instances.get(elements);
        if (t == null) {
            t = new SetType<T>(elements);
            instances.put(elements, t);
        }
        return t;
    }

    public SetType(AbstractType<T> elements) {
        super(CollectionType.Kind.SET);
        this.elements = elements;
        this.serializer = SetSerializer.getInstance(elements.getSerializer());
    }

    @Override
    public AbstractType<T> nameComparator() {
        return this.elements;
    }

    @Override
    public AbstractType<?> valueComparator() {
        return EmptyType.instance;
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        return ListType.compareListOrSet(this.elements, o1, o2);
    }

    @Override
    public TypeSerializer<Set<T>> getSerializer() {
        return this.serializer;
    }

    @Override
    protected void appendToStringBuilder(StringBuilder sb) {
        sb.append(this.getClass().getName()).append(TypeParser.stringifyTypeParameters(Collections.singletonList(this.elements)));
    }

    @Override
    public ByteBuffer serialize(CFDefinition.Name name, List<Pair<ByteBuffer, Column>> columns) {
        columns = this.enforceLimit(name, columns);
        ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>(columns.size());
        int size = 0;
        for (Pair<ByteBuffer, Column> p : columns) {
            bbs.add((ByteBuffer)p.left);
            size += 2 + ((ByteBuffer)p.left).remaining();
        }
        return SetType.pack(bbs, columns.size(), size);
    }
}

