/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal;

import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.CQL3Type;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.DateType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.LongType;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.MarshalException;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.TimestampSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.TypeSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import java.nio.ByteBuffer;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampType
extends AbstractType<Date> {
    private static final Logger logger = LoggerFactory.getLogger(TimestampType.class);
    public static final TimestampType instance = new TimestampType();

    private TimestampType() {
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        return LongType.compareLongs(o1, o2);
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        return ByteBufferUtil.bytes(TimestampSerializer.dateStringToTimestamp(source));
    }

    @Override
    public boolean isCompatibleWith(AbstractType<?> previous) {
        if (super.isCompatibleWith(previous)) {
            return true;
        }
        if (previous instanceof DateType) {
            logger.warn("Changing from DateType to TimestampType is allowed, but be wary that they sort differently for pre-unix-epoch timestamps (negative timestamp values) and thus this change will corrupt your data if you have such negative timestamp. So unless you know that you don't have *any* pre-unix-epoch timestamp you should change back to DateType");
            return true;
        }
        return false;
    }

    @Override
    public boolean isValueCompatibleWithInternal(AbstractType<?> otherType) {
        return this == otherType || otherType == DateType.instance || otherType == LongType.instance;
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.TIMESTAMP;
    }

    @Override
    public TypeSerializer<Date> getSerializer() {
        return TimestampSerializer.instance;
    }
}

