/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.gms;

import com.netflix.astyanax.shaded.org.apache.cassandra.gms.GossipDigestSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.IVersionedSerializer;
import java.net.InetAddress;

public class GossipDigest
implements Comparable<GossipDigest> {
    public static final IVersionedSerializer<GossipDigest> serializer = new GossipDigestSerializer();
    final InetAddress endpoint;
    final int generation;
    final int maxVersion;

    GossipDigest(InetAddress ep, int gen, int version) {
        this.endpoint = ep;
        this.generation = gen;
        this.maxVersion = version;
    }

    InetAddress getEndpoint() {
        return this.endpoint;
    }

    int getGeneration() {
        return this.generation;
    }

    int getMaxVersion() {
        return this.maxVersion;
    }

    @Override
    public int compareTo(GossipDigest gDigest) {
        if (this.generation != gDigest.generation) {
            return this.generation - gDigest.generation;
        }
        return this.maxVersion - gDigest.maxVersion;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.endpoint);
        sb.append(":");
        sb.append(this.generation);
        sb.append(":");
        sb.append(this.maxVersion);
        return sb.toString();
    }
}

