/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.io.sstable;

import com.google.common.base.Objects;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.sstable.Component;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.Pair;
import java.io.File;
import java.util.StringTokenizer;

public class Descriptor {
    public final File directory;
    public final Version version;
    public final String ksname;
    public final String cfname;
    public final int generation;
    public final boolean temporary;
    private final int hashCode;

    public Descriptor(File directory, String ksname, String cfname, int generation, boolean temp) {
        this(Version.CURRENT, directory, ksname, cfname, generation, temp);
    }

    public Descriptor(String version, File directory, String ksname, String cfname, int generation, boolean temp) {
        this(new Version(version), directory, ksname, cfname, generation, temp);
    }

    public Descriptor(Version version, File directory, String ksname, String cfname, int generation, boolean temp) {
        assert (version != null && directory != null && ksname != null && cfname != null);
        this.version = version;
        this.directory = directory;
        this.ksname = ksname;
        this.cfname = cfname;
        this.generation = generation;
        this.temporary = temp;
        this.hashCode = Objects.hashCode((Object[])new Object[]{directory, generation, ksname, cfname, temp});
    }

    public Descriptor withGeneration(int newGeneration) {
        return new Descriptor(this.version, this.directory, this.ksname, this.cfname, newGeneration, this.temporary);
    }

    public String filenameFor(Component component) {
        return this.filenameFor(component.name());
    }

    public String baseFilename() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.directory).append(File.separatorChar);
        buff.append(this.ksname).append('-');
        buff.append(this.cfname).append('-');
        if (this.temporary) {
            buff.append("tmp").append('-');
        }
        buff.append(this.version).append('-');
        buff.append(this.generation);
        return buff.toString();
    }

    public String filenameFor(String suffix) {
        return this.baseFilename() + '-' + suffix;
    }

    public static Descriptor fromFilename(String filename) {
        File file = new File(filename);
        return (Descriptor)Descriptor.fromFilename((File)file.getParentFile(), (String)file.getName(), (boolean)false).left;
    }

    public static Descriptor fromFilename(String filename, boolean skipComponent) {
        File file = new File(filename);
        return (Descriptor)Descriptor.fromFilename((File)file.getParentFile(), (String)file.getName(), (boolean)skipComponent).left;
    }

    public static Pair<Descriptor, String> fromFilename(File directory, String name) {
        return Descriptor.fromFilename(directory, name, false);
    }

    public static Pair<Descriptor, String> fromFilename(File directory, String name, boolean skipComponent) {
        StringTokenizer st = new StringTokenizer(name, String.valueOf('-'));
        String ksname = st.nextToken();
        String cfname = st.nextToken();
        String nexttok = st.nextToken();
        boolean temporary = false;
        if (nexttok.equals("tmp")) {
            temporary = true;
            nexttok = st.nextToken();
        }
        if (!Version.validate(nexttok)) {
            throw new UnsupportedOperationException("SSTable " + name + " is too old to open.  Upgrade to 1.2.5 first, and run upgradesstables");
        }
        Version version = new Version(nexttok);
        nexttok = st.nextToken();
        int generation = Integer.parseInt(nexttok);
        String component = null;
        if (!skipComponent) {
            component = st.nextToken();
        }
        directory = directory != null ? directory : new File(".");
        return Pair.create(new Descriptor(version, directory, ksname, cfname, generation, temporary), component);
    }

    public Descriptor asTemporary(boolean temporary) {
        return new Descriptor(this.version, this.directory, this.ksname, this.cfname, this.generation, temporary);
    }

    public boolean isCompatible() {
        return this.version.isCompatible();
    }

    public boolean isStreamCompatible() {
        return this.version.isStreamCompatible();
    }

    public String toString() {
        return this.baseFilename();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Descriptor)) {
            return false;
        }
        Descriptor that = (Descriptor)o;
        return that.directory.equals(this.directory) && that.generation == this.generation && that.ksname.equals(this.ksname) && that.cfname.equals(this.cfname) && that.temporary == this.temporary;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static class Version {
        public static final String current_version = "jb";
        public static final Version CURRENT = new Version("jb");
        private final String version;
        public final boolean isLatestVersion;
        public final boolean hasSuperColumns;
        public final boolean tracksMaxLocalDeletionTime;
        public final boolean hasBloomFilterFPChance;
        public final boolean offHeapSummaries;
        public final boolean hasRowSizeAndColumnCount;
        public final boolean tracksMaxMinColumnNames;
        public final boolean hasPostCompressionAdlerChecksums;

        public Version(String version) {
            this.version = version;
            this.tracksMaxLocalDeletionTime = version.compareTo("ja") >= 0;
            this.isLatestVersion = version.compareTo(current_version) == 0;
            this.hasSuperColumns = version.compareTo("ja") < 0;
            this.hasBloomFilterFPChance = version.compareTo("ja") >= 0;
            this.offHeapSummaries = version.compareTo("ja") >= 0;
            this.hasRowSizeAndColumnCount = version.compareTo("ja") < 0;
            this.tracksMaxMinColumnNames = version.compareTo("ja") >= 0;
            this.hasPostCompressionAdlerChecksums = version.compareTo(current_version) >= 0;
        }

        static boolean validate(String ver) {
            return ver != null && ver.matches("[a-z]+");
        }

        public boolean isCompatible() {
            return this.version.compareTo("ic") >= 0 && this.version.charAt(0) <= Version.CURRENT.version.charAt(0);
        }

        public boolean isStreamCompatible() {
            return this.isCompatible() && this.version.charAt(0) >= 'j';
        }

        public String toString() {
            return this.version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Version)) {
                return false;
            }
            return this.version.equals(((Version)o).version);
        }

        public int hashCode() {
            return this.version.hashCode();
        }
    }
}

