/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.io.util;

import com.google.common.util.concurrent.RateLimiter;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.RandomAccessReader;
import java.io.File;
import java.io.FileNotFoundException;

public class ThrottledReader
extends RandomAccessReader {
    private final RateLimiter limiter;

    protected ThrottledReader(File file, RateLimiter limiter) throws FileNotFoundException {
        super(file, 65536, null);
        this.limiter = limiter;
    }

    @Override
    protected void reBuffer() {
        this.limiter.acquire(this.buffer.length);
        super.reBuffer();
    }

    public static ThrottledReader open(File file, RateLimiter limiter) {
        try {
            return new ThrottledReader(file, limiter);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

