/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.locator;

import com.netflix.astyanax.shaded.org.apache.cassandra.config.DatabaseDescriptor;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.ConfigurationException;
import com.netflix.astyanax.shaded.org.apache.cassandra.gms.ApplicationState;
import com.netflix.astyanax.shaded.org.apache.cassandra.gms.Gossiper;
import com.netflix.astyanax.shaded.org.apache.cassandra.locator.Ec2Snitch;
import com.netflix.astyanax.shaded.org.apache.cassandra.locator.ReconnectableSnitchHelper;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.StorageService;
import java.io.IOException;
import java.net.InetAddress;

public class Ec2MultiRegionSnitch
extends Ec2Snitch {
    private static final String PUBLIC_IP_QUERY_URL = "http://169.254.169.254/latest/meta-data/public-ipv4";
    private static final String PRIVATE_IP_QUERY_URL = "http://169.254.169.254/latest/meta-data/local-ipv4";
    private final InetAddress localPublicAddress = InetAddress.getByName(this.awsApiCall("http://169.254.169.254/latest/meta-data/public-ipv4"));
    private final String localPrivateAddress;

    public Ec2MultiRegionSnitch() throws IOException, ConfigurationException {
        logger.info("EC2Snitch using publicIP as identifier: " + this.localPublicAddress);
        this.localPrivateAddress = this.awsApiCall(PRIVATE_IP_QUERY_URL);
        DatabaseDescriptor.setBroadcastAddress(this.localPublicAddress);
    }

    @Override
    public void gossiperStarting() {
        super.gossiperStarting();
        Gossiper.instance.addLocalApplicationState(ApplicationState.INTERNAL_IP, StorageService.instance.valueFactory.internalIP(this.localPrivateAddress));
        Gossiper.instance.register(new ReconnectableSnitchHelper(this, this.ec2region, true));
    }
}

