/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.metrics;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.commitlog.CommitLogAllocator;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.commitlog.ICommitLogExecutorService;
import com.netflix.astyanax.shaded.org.apache.cassandra.metrics.DefaultNameFactory;
import com.netflix.astyanax.shaded.org.apache.cassandra.metrics.MetricNameFactory;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;

public class CommitLogMetrics {
    public static final MetricNameFactory factory = new DefaultNameFactory("CommitLog");
    public final Gauge<Long> completedTasks;
    public final Gauge<Long> pendingTasks;
    public final Gauge<Long> totalCommitLogSize;

    public CommitLogMetrics(final ICommitLogExecutorService executor, final CommitLogAllocator allocator) {
        this.completedTasks = Metrics.newGauge((MetricName)factory.createMetricName("CompletedTasks"), (Gauge)new Gauge<Long>(){

            public Long value() {
                return executor.getCompletedTasks();
            }
        });
        this.pendingTasks = Metrics.newGauge((MetricName)factory.createMetricName("PendingTasks"), (Gauge)new Gauge<Long>(){

            public Long value() {
                return executor.getPendingTasks();
            }
        });
        this.totalCommitLogSize = Metrics.newGauge((MetricName)factory.createMetricName("TotalCommitLogSize"), (Gauge)new Gauge<Long>(){

            public Long value() {
                return allocator.bytesUsed();
            }
        });
    }
}

