/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.metrics;

import com.netflix.astyanax.shaded.org.apache.cassandra.metrics.MetricNameFactory;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.util.concurrent.ThreadPoolExecutor;

public class ThreadPoolMetrics {
    public final Gauge<Integer> activeTasks;
    public final Counter totalBlocked;
    public final Counter currentBlocked;
    public final Gauge<Long> completedTasks;
    public final Gauge<Long> pendingTasks;
    private MetricNameFactory factory;

    public ThreadPoolMetrics(final ThreadPoolExecutor executor, String path, String poolName) {
        this.factory = new ThreadPoolMetricNameFactory(path, poolName);
        this.activeTasks = Metrics.newGauge((MetricName)this.factory.createMetricName("ActiveTasks"), (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return executor.getActiveCount();
            }
        });
        this.totalBlocked = Metrics.newCounter((MetricName)this.factory.createMetricName("TotalBlockedTasks"));
        this.currentBlocked = Metrics.newCounter((MetricName)this.factory.createMetricName("CurrentlyBlockedTasks"));
        this.completedTasks = Metrics.newGauge((MetricName)this.factory.createMetricName("CompletedTasks"), (Gauge)new Gauge<Long>(){

            public Long value() {
                return executor.getCompletedTaskCount();
            }
        });
        this.pendingTasks = Metrics.newGauge((MetricName)this.factory.createMetricName("PendingTasks"), (Gauge)new Gauge<Long>(){

            public Long value() {
                return executor.getTaskCount() - executor.getCompletedTaskCount();
            }
        });
    }

    public void release() {
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("ActiveTasks"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("PendingTasks"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("CompletedTasks"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("TotalBlockedTasks"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("CurrentlyBlockedTasks"));
    }

    class ThreadPoolMetricNameFactory
    implements MetricNameFactory {
        private final String path;
        private final String poolName;

        ThreadPoolMetricNameFactory(String path, String poolName) {
            this.path = path;
            this.poolName = poolName;
        }

        @Override
        public MetricName createMetricName(String metricName) {
            String groupName = ThreadPoolMetrics.class.getPackage().getName();
            String type = "ThreadPools";
            StringBuilder mbeanName = new StringBuilder();
            mbeanName.append(groupName).append(":");
            mbeanName.append("type=").append(type);
            mbeanName.append(",path=").append(this.path);
            mbeanName.append(",scope=").append(this.poolName);
            mbeanName.append(",name=").append(metricName);
            return new MetricName(groupName, type, metricName, this.path + "." + this.poolName, mbeanName.toString());
        }
    }
}

