/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.net;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.ConsistencyLevel;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.IVersionedSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.CallbackInfo;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.IAsyncCallback;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessageOut;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessagingService;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.StorageProxy;
import java.net.InetAddress;

public class WriteCallbackInfo
extends CallbackInfo {
    public final MessageOut sentMessage;
    private final ConsistencyLevel consistencyLevel;
    private final boolean allowHints;

    public WriteCallbackInfo(InetAddress target, IAsyncCallback callback, MessageOut message, IVersionedSerializer<?> serializer, ConsistencyLevel consistencyLevel, boolean allowHints) {
        super(target, callback, serializer);
        assert (message != null);
        this.sentMessage = message;
        this.consistencyLevel = consistencyLevel;
        this.allowHints = allowHints;
    }

    @Override
    public boolean shouldHint() {
        return this.allowHints && this.sentMessage.verb != MessagingService.Verb.COUNTER_MUTATION && this.consistencyLevel != ConsistencyLevel.ANY && StorageProxy.shouldHint(this.target);
    }
}

