/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.repair;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.SystemKeyspace;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessagingService;
import com.netflix.astyanax.shaded.org.apache.cassandra.repair.RepairJobDesc;
import com.netflix.astyanax.shaded.org.apache.cassandra.repair.messages.SyncComplete;
import com.netflix.astyanax.shaded.org.apache.cassandra.repair.messages.SyncRequest;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.StreamEvent;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.StreamEventHandler;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.StreamPlan;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.StreamResultFuture;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.StreamState;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.FBUtilities;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingRepairTask
implements Runnable,
StreamEventHandler {
    private static final Logger logger = LoggerFactory.getLogger(StreamingRepairTask.class);
    public final RepairJobDesc desc;
    public final SyncRequest request;

    public StreamingRepairTask(RepairJobDesc desc, SyncRequest request) {
        this.desc = desc;
        this.request = request;
    }

    @Override
    public void run() {
        if (this.request.src.equals(FBUtilities.getBroadcastAddress())) {
            this.initiateStreaming();
        } else {
            this.forwardToSource();
        }
    }

    private void initiateStreaming() {
        InetAddress dest = this.request.dst;
        InetAddress preferred = SystemKeyspace.getPreferredIP(dest);
        logger.info(String.format("[streaming task #%s] Performing streaming repair of %d ranges with %s", this.desc.sessionId, this.request.ranges.size(), this.request.dst));
        StreamResultFuture op = new StreamPlan("Repair").flushBeforeTransfer(true).requestRanges(dest, preferred, this.desc.keyspace, this.request.ranges, this.desc.columnFamily).transferRanges(dest, preferred, this.desc.keyspace, this.request.ranges, this.desc.columnFamily).execute();
        op.addEventListener(this);
    }

    private void forwardToSource() {
        logger.info(String.format("[repair #%s] Forwarding streaming repair of %d ranges to %s (to be streamed with %s)", this.desc.sessionId, this.request.ranges.size(), this.request.src, this.request.dst));
        MessagingService.instance().sendOneWay(this.request.createMessage(), this.request.src);
    }

    @Override
    public void handleStreamEvent(StreamEvent event) {
    }

    public void onSuccess(StreamState state) {
        logger.info(String.format("[repair #%s] streaming task succeed, returning response to %s", this.desc.sessionId, this.request.initiator));
        MessagingService.instance().sendOneWay(new SyncComplete(this.desc, this.request.src, this.request.dst, true).createMessage(), this.request.initiator);
    }

    public void onFailure(Throwable t) {
        MessagingService.instance().sendOneWay(new SyncComplete(this.desc, this.request.src, this.request.dst, false).createMessage(), this.request.initiator);
    }
}

