/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.repair.messages;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.TypeSizes;
import com.netflix.astyanax.shaded.org.apache.cassandra.repair.NodePair;
import com.netflix.astyanax.shaded.org.apache.cassandra.repair.RepairJobDesc;
import com.netflix.astyanax.shaded.org.apache.cassandra.repair.messages.RepairMessage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;

public class SyncComplete
extends RepairMessage {
    public static final RepairMessage.MessageSerializer serializer = new SyncCompleteSerializer();
    public final NodePair nodes;
    public final boolean success;

    public SyncComplete(RepairJobDesc desc, NodePair nodes, boolean success) {
        super(RepairMessage.Type.SYNC_COMPLETE, desc);
        this.nodes = nodes;
        this.success = success;
    }

    public SyncComplete(RepairJobDesc desc, InetAddress endpoint1, InetAddress endpoint2, boolean success) {
        super(RepairMessage.Type.SYNC_COMPLETE, desc);
        this.nodes = new NodePair(endpoint1, endpoint2);
        this.success = success;
    }

    private static class SyncCompleteSerializer
    implements RepairMessage.MessageSerializer<SyncComplete> {
        private SyncCompleteSerializer() {
        }

        @Override
        public void serialize(SyncComplete message, DataOutput out, int version) throws IOException {
            RepairJobDesc.serializer.serialize(message.desc, out, version);
            NodePair.serializer.serialize(message.nodes, out, version);
            out.writeBoolean(message.success);
        }

        @Override
        public SyncComplete deserialize(DataInput in, int version) throws IOException {
            RepairJobDesc desc = RepairJobDesc.serializer.deserialize(in, version);
            NodePair nodes = NodePair.serializer.deserialize(in, version);
            return new SyncComplete(desc, nodes, in.readBoolean());
        }

        @Override
        public long serializedSize(SyncComplete message, int version) {
            long size = RepairJobDesc.serializer.serializedSize(message.desc, version);
            size += NodePair.serializer.serializedSize(message.nodes, version);
            return size += (long)TypeSizes.NATIVE.sizeof(message.success);
        }
    }
}

