/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.serializers;

import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.AbstractTextSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.MarshalException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class AsciiSerializer
extends AbstractTextSerializer {
    public static final AsciiSerializer instance = new AsciiSerializer();

    private AsciiSerializer() {
        super(StandardCharsets.US_ASCII);
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        for (int i = bytes.position(); i < bytes.limit(); ++i) {
            byte b = bytes.get(i);
            if (b >= 0 && b <= 127) continue;
            throw new MarshalException("Invalid byte for ascii: " + Byte.toString(b));
        }
    }
}

