/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.serializers;

import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.MarshalException;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.TypeSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class IntegerSerializer
implements TypeSerializer<BigInteger> {
    public static final IntegerSerializer instance = new IntegerSerializer();

    @Override
    public BigInteger deserialize(ByteBuffer bytes) {
        return bytes.hasRemaining() ? new BigInteger(ByteBufferUtil.getArray(bytes)) : null;
    }

    @Override
    public ByteBuffer serialize(BigInteger value) {
        return value == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : ByteBuffer.wrap(value.toByteArray());
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
    }

    @Override
    public String toString(BigInteger value) {
        return value == null ? "" : value.toString(10);
    }

    @Override
    public Class<BigInteger> getType() {
        return BigInteger.class;
    }
}

