/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.service;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.DecoratedKey;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ReadResponse;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Row;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessageIn;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.IResponseResolver;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.StorageService;
import java.nio.ByteBuffer;
import java.util.Set;
import org.cliffc.high_scale_lib.NonBlockingHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRowResolver
implements IResponseResolver<ReadResponse, Row> {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractRowResolver.class);
    protected final String keyspaceName;
    protected final Set<MessageIn<ReadResponse>> replies = new NonBlockingHashSet();
    protected final DecoratedKey key;

    public AbstractRowResolver(ByteBuffer key, String keyspaceName) {
        this.key = StorageService.getPartitioner().decorateKey(key);
        this.keyspaceName = keyspaceName;
    }

    @Override
    public void preprocess(MessageIn<ReadResponse> message) {
        this.replies.add(message);
    }

    @Override
    public Iterable<MessageIn<ReadResponse>> getMessages() {
        return this.replies;
    }
}

