/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.service;

import com.netflix.astyanax.shaded.org.apache.cassandra.concurrent.Stage;
import com.netflix.astyanax.shaded.org.apache.cassandra.concurrent.StageManager;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ReadResponse;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.IAsyncCallback;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessageIn;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.DigestMismatchException;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.RowDataResolver;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.WrappedRunnable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public class AsyncRepairCallback
implements IAsyncCallback<ReadResponse> {
    private final RowDataResolver repairResolver;
    private final int blockfor;
    protected final AtomicInteger received = new AtomicInteger(0);

    public AsyncRepairCallback(RowDataResolver repairResolver, int blockfor) {
        this.repairResolver = repairResolver;
        this.blockfor = blockfor;
    }

    @Override
    public void response(MessageIn<ReadResponse> message) {
        this.repairResolver.preprocess(message);
        if (this.received.incrementAndGet() == this.blockfor) {
            StageManager.getStage(Stage.READ_REPAIR).execute(new WrappedRunnable(){

                @Override
                protected void runMayThrow() throws DigestMismatchException, IOException {
                    AsyncRepairCallback.this.repairResolver.resolve();
                }
            });
        }
    }

    @Override
    public boolean isLatencyForSnitch() {
        return true;
    }
}

