/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.service;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.ConsistencyLevel;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Keyspace;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.WriteType;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessageIn;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.WriteResponseHandler;
import java.net.InetAddress;
import java.util.Collection;

public class DatacenterWriteResponseHandler
extends WriteResponseHandler {
    public DatacenterWriteResponseHandler(Collection<InetAddress> naturalEndpoints, Collection<InetAddress> pendingEndpoints, ConsistencyLevel consistencyLevel, Keyspace keyspace, Runnable callback, WriteType writeType) {
        super(naturalEndpoints, pendingEndpoints, consistencyLevel, keyspace, callback, writeType);
        assert (consistencyLevel.isDatacenterLocal());
    }

    @Override
    public void response(MessageIn message) {
        if ((message == null || this.consistencyLevel.isLocal(message.from)) && this.responses.decrementAndGet() == 0) {
            this.signal();
        }
    }

    @Override
    protected int totalBlockFor() {
        return this.consistencyLevel.blockFor(this.keyspace) + this.consistencyLevel.countLocalEndpoints(this.pendingEndpoints);
    }
}

