/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.service.pager;

import com.netflix.astyanax.shaded.org.apache.cassandra.config.Schema;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamily;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamilyStore;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ConsistencyLevel;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.EmptyColumns;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.RangeSliceCommand;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ReadCommand;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Row;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.SliceByNamesReadCommand;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.SliceFromReadCommand;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.columniterator.IdentityQueryFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.ColumnCounter;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.NamesQueryFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.SliceQueryFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.RequestExecutionException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.RequestValidationException;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.pager.MultiPartitionPager;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.pager.NamesQueryPager;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.pager.Pageable;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.pager.PagingState;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.pager.QueryPager;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.pager.RangeNamesQueryPager;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.pager.RangeSliceQueryPager;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.pager.SliceQueryPager;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;

public class QueryPagers {
    private QueryPagers() {
    }

    private static int maxQueried(ReadCommand command) {
        if (command instanceof SliceByNamesReadCommand) {
            NamesQueryFilter filter = ((SliceByNamesReadCommand)command).filter;
            return filter.countCQL3Rows() ? 1 : filter.columns.size();
        }
        SliceQueryFilter filter = ((SliceFromReadCommand)command).filter;
        return filter.count;
    }

    public static boolean mayNeedPaging(Pageable command, int pageSize) {
        if (command instanceof Pageable.ReadCommands) {
            List<ReadCommand> commands = ((Pageable.ReadCommands)command).commands;
            long maxQueried = 0L;
            for (ReadCommand readCmd : commands) {
                maxQueried += (long)QueryPagers.maxQueried(readCmd);
            }
            return maxQueried > (long)pageSize;
        }
        if (command instanceof ReadCommand) {
            return QueryPagers.maxQueried((ReadCommand)command) > pageSize;
        }
        assert (command instanceof RangeSliceCommand);
        RangeSliceCommand rsc = (RangeSliceCommand)command;
        assert (rsc.countCQL3Rows || rsc.predicate instanceof SliceQueryFilter && ((SliceQueryFilter)rsc.predicate).count == 1);
        return rsc.maxResults > pageSize;
    }

    private static QueryPager pager(ReadCommand command, ConsistencyLevel consistencyLevel, boolean local, PagingState state) {
        if (command instanceof SliceByNamesReadCommand) {
            return new NamesQueryPager((SliceByNamesReadCommand)command, consistencyLevel, local);
        }
        return new SliceQueryPager((SliceFromReadCommand)command, consistencyLevel, local, state);
    }

    private static QueryPager pager(Pageable command, ConsistencyLevel consistencyLevel, boolean local, PagingState state) {
        if (command instanceof Pageable.ReadCommands) {
            List<ReadCommand> commands = ((Pageable.ReadCommands)command).commands;
            if (commands.size() == 1) {
                return QueryPagers.pager(commands.get(0), consistencyLevel, local, state);
            }
            return new MultiPartitionPager(commands, consistencyLevel, local, state, ((Pageable.ReadCommands)command).limitForQuery);
        }
        if (command instanceof ReadCommand) {
            return QueryPagers.pager((ReadCommand)command, consistencyLevel, local, state);
        }
        assert (command instanceof RangeSliceCommand);
        RangeSliceCommand rangeCommand = (RangeSliceCommand)command;
        if (rangeCommand.predicate instanceof NamesQueryFilter) {
            return new RangeNamesQueryPager(rangeCommand, consistencyLevel, local, state);
        }
        return new RangeSliceQueryPager(rangeCommand, consistencyLevel, local, state);
    }

    public static QueryPager pager(Pageable command, ConsistencyLevel consistencyLevel, PagingState state) {
        return QueryPagers.pager(command, consistencyLevel, false, state);
    }

    public static QueryPager localPager(Pageable command) {
        return QueryPagers.pager(command, null, true, null);
    }

    public static Iterator<ColumnFamily> pageRowLocally(final ColumnFamilyStore cfs, ByteBuffer key, final int pageSize) {
        SliceFromReadCommand command = new SliceFromReadCommand(cfs.metadata.ksName, key, cfs.name, System.currentTimeMillis(), new IdentityQueryFilter());
        final SliceQueryPager pager = new SliceQueryPager(command, null, true);
        return new Iterator<ColumnFamily>(){

            @Override
            public boolean hasNext() {
                return !pager.isExhausted();
            }

            @Override
            public ColumnFamily next() {
                try {
                    List rows = pager.fetchPage(pageSize);
                    ColumnFamily cf = rows.isEmpty() ? null : ((Row)rows.get((int)0)).cf;
                    return cf == null ? EmptyColumns.factory.create(cfs.metadata) : cf;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static int countPaged(String keyspace, String columnFamily, ByteBuffer key, SliceQueryFilter filter, ConsistencyLevel consistencyLevel, int pageSize, long now) throws RequestValidationException, RequestExecutionException {
        SliceFromReadCommand command = new SliceFromReadCommand(keyspace, key, columnFamily, now, filter);
        SliceQueryPager pager = new SliceQueryPager(command, consistencyLevel, false);
        ColumnCounter counter = filter.columnCounter(Schema.instance.getComparator(keyspace, columnFamily), now);
        while (!pager.isExhausted()) {
            List next = pager.fetchPage(pageSize);
            if (next.isEmpty()) continue;
            counter.countAll(((Row)next.get((int)0)).cf);
        }
        return counter.live();
    }
}

