/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.service.pager;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.Column;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ConsistencyLevel;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.DecoratedKey;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.PagedRangeCommand;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.RangeSliceCommand;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Row;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.RowPosition;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.SliceQueryFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.AbstractBounds;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.Bounds;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.IncludingExcludingBounds;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.Range;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.RequestExecutionException;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.StorageProxy;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.StorageService;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.pager.AbstractQueryPager;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.pager.PagingState;
import java.nio.ByteBuffer;
import java.util.List;

public class RangeSliceQueryPager
extends AbstractQueryPager {
    private final RangeSliceCommand command;
    private volatile DecoratedKey lastReturnedKey;
    private volatile ByteBuffer lastReturnedName;

    RangeSliceQueryPager(RangeSliceCommand command, ConsistencyLevel consistencyLevel, boolean localQuery) {
        super(consistencyLevel, command.maxResults, localQuery, command.keyspace, command.columnFamily, command.predicate, command.timestamp);
        this.command = command;
        assert (this.columnFilter instanceof SliceQueryFilter);
    }

    RangeSliceQueryPager(RangeSliceCommand command, ConsistencyLevel consistencyLevel, boolean localQuery, PagingState state) {
        this(command, consistencyLevel, localQuery);
        if (state != null) {
            this.lastReturnedKey = StorageService.getPartitioner().decorateKey(state.partitionKey);
            this.lastReturnedName = state.cellName;
            this.restoreState(state.remaining, true);
        }
    }

    @Override
    public PagingState state() {
        return this.lastReturnedKey == null ? null : new PagingState(this.lastReturnedKey.key, this.lastReturnedName, this.maxRemaining());
    }

    @Override
    protected List<Row> queryNextPage(int pageSize, ConsistencyLevel consistencyLevel, boolean localQuery) throws RequestExecutionException {
        SliceQueryFilter sf = (SliceQueryFilter)this.columnFilter;
        AbstractBounds<RowPosition> keyRange = this.lastReturnedKey == null ? this.command.keyRange : this.makeIncludingKeyBounds(this.lastReturnedKey);
        ByteBuffer start = this.lastReturnedName == null ? sf.start() : this.lastReturnedName;
        PagedRangeCommand pageCmd = new PagedRangeCommand(this.command.keyspace, this.command.columnFamily, this.command.timestamp, keyRange, sf, start, sf.finish(), this.command.rowFilter, pageSize);
        return localQuery ? pageCmd.executeLocally() : StorageProxy.getRangeSlice(pageCmd, consistencyLevel);
    }

    @Override
    protected boolean containsPreviousLast(Row first) {
        if (this.lastReturnedKey == null || !this.lastReturnedKey.equals(first.key)) {
            return false;
        }
        Column firstColumn = this.isReversed() ? RangeSliceQueryPager.lastColumn(first.cf) : this.firstNonStaticColumn(first.cf);
        return !first.cf.deletionInfo().isDeleted(firstColumn) && firstColumn.isLive(this.timestamp()) && this.lastReturnedName.equals(firstColumn.name());
    }

    @Override
    protected boolean recordLast(Row last) {
        this.lastReturnedKey = last.key;
        this.lastReturnedName = (this.isReversed() ? this.firstNonStaticColumn(last.cf) : RangeSliceQueryPager.lastColumn(last.cf)).name();
        return true;
    }

    @Override
    protected boolean isReversed() {
        return ((SliceQueryFilter)this.command.predicate).reversed;
    }

    private AbstractBounds<RowPosition> makeIncludingKeyBounds(RowPosition lastReturnedKey) {
        AbstractBounds bounds = this.command.keyRange;
        if (bounds instanceof Range || bounds instanceof Bounds) {
            return new Bounds<RowPosition>(lastReturnedKey, (RowPosition)bounds.right);
        }
        return new IncludingExcludingBounds<RowPosition>(lastReturnedKey, (RowPosition)bounds.right);
    }
}

