/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.streaming;

import com.netflix.astyanax.shaded.org.apache.cassandra.config.DatabaseDescriptor;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.OutboundTcpConnectionPool;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.StreamConnectionFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConnectionFactory
implements StreamConnectionFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultConnectionFactory.class);
    private static final int MAX_CONNECT_ATTEMPTS = 3;

    @Override
    public Socket createConnection(InetAddress peer) throws IOException {
        int attempts = 0;
        while (true) {
            try {
                Socket socket = OutboundTcpConnectionPool.newSocket(peer);
                socket.setSoTimeout(DatabaseDescriptor.getStreamingSocketTimeout());
                socket.setKeepAlive(true);
                return socket;
            }
            catch (IOException e) {
                if (++attempts >= 3) {
                    throw e;
                }
                long waitms = DatabaseDescriptor.getRpcTimeout() * (long)Math.pow(2.0, attempts);
                logger.warn("Failed attempt " + attempts + " to connect to " + peer + ". Retrying in " + waitms + " ms. (" + e + ")");
                try {
                    Thread.sleep(waitms);
                }
                catch (InterruptedException wtf) {
                    throw new IOException("interrupted", wtf);
                }
            }
        }
    }
}

