/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.streaming;

import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.ProgressInfo;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.SessionInfo;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.StreamSession;
import java.net.InetAddress;
import java.util.UUID;

public abstract class StreamEvent {
    public final Type eventType;
    public final UUID planId;

    protected StreamEvent(Type eventType, UUID planId) {
        this.eventType = eventType;
        this.planId = planId;
    }

    public static class SessionPreparedEvent
    extends StreamEvent {
        public final SessionInfo session;

        public SessionPreparedEvent(UUID planId, SessionInfo session) {
            super(Type.STREAM_PREPARED, planId);
            this.session = session;
        }
    }

    public static class ProgressEvent
    extends StreamEvent {
        public final ProgressInfo progress;

        public ProgressEvent(UUID planId, ProgressInfo progress) {
            super(Type.FILE_PROGRESS, planId);
            this.progress = progress;
        }

        public String toString() {
            return "<ProgressEvent " + this.progress.toString() + ">";
        }
    }

    public static class SessionCompleteEvent
    extends StreamEvent {
        public final InetAddress peer;
        public final boolean success;

        public SessionCompleteEvent(StreamSession session) {
            super(Type.STREAM_COMPLETE, session.planId());
            this.peer = session.peer;
            this.success = session.isSuccess();
        }
    }

    public static enum Type {
        STREAM_PREPARED,
        STREAM_COMPLETE,
        FILE_PROGRESS;

    }
}

