/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.transport;

import com.netflix.astyanax.shaded.org.apache.cassandra.config.DatabaseDescriptor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
final class ConnectionLimitHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionLimitHandler.class);
    private final ConcurrentMap<InetAddress, AtomicLong> connectionsPerClient = new ConcurrentHashMap<InetAddress, AtomicLong>();
    private final AtomicLong counter = new AtomicLong(0L);

    ConnectionLimitHandler() {
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent event) throws Exception {
        long count = this.counter.incrementAndGet();
        long limit = DatabaseDescriptor.getNativeTransportMaxConcurrentConnections();
        if (limit < 0L) {
            limit = Long.MAX_VALUE;
        }
        if (count > limit) {
            logger.warn("Exceeded maximum native connection limit of {} by using {} connections", (Object)limit, (Object)count);
            ctx.getChannel().close();
        } else {
            long perIpLimit = DatabaseDescriptor.getNativeTransportMaxConcurrentConnectionsPerIp();
            if (perIpLimit > 0L) {
                AtomicLong old;
                InetAddress address = ((InetSocketAddress)ctx.getChannel().getRemoteAddress()).getAddress();
                AtomicLong perIpCount = (AtomicLong)this.connectionsPerClient.get(address);
                if (perIpCount == null && (old = this.connectionsPerClient.putIfAbsent(address, perIpCount = new AtomicLong(0L))) != null) {
                    perIpCount = old;
                }
                if (perIpCount.incrementAndGet() > perIpLimit) {
                    logger.warn("Exceeded maximum native connection limit per ip of {} by using {} connections", (Object)perIpLimit, (Object)perIpCount);
                    ctx.getChannel().close();
                    return;
                }
            }
            super.channelOpen(ctx, event);
        }
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent event) throws Exception {
        this.counter.decrementAndGet();
        InetAddress address = ((InetSocketAddress)ctx.getChannel().getRemoteAddress()).getAddress();
        AtomicLong count = (AtomicLong)this.connectionsPerClient.get(address);
        if (count != null && count.decrementAndGet() <= 0L) {
            this.connectionsPerClient.remove(address);
        }
        super.channelClosed(ctx, event);
    }
}

