/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.transport;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.QueryState;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.CBCodec;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.CBUtil;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.Connection;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.Frame;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.ProtocolException;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.ServerConnection;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.AuthChallenge;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.AuthResponse;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.AuthSuccess;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.AuthenticateMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.BatchMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.CredentialsMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.ErrorMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.EventMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.ExecuteMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.OptionsMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.PrepareMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.QueryMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.ReadyMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.RegisterMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.ResultMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.StartupMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.SupportedMessage;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import java.util.UUID;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.oneone.OneToOneDecoder;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Message {
    protected static final Logger logger = LoggerFactory.getLogger(Message.class);
    private static final Set<String> ioExceptionsAtDebugLevel = ImmutableSet.builder().add((Object)"Connection reset by peer").add((Object)"Broken pipe").add((Object)"Connection timed out").build();
    public final Type type;
    protected volatile Connection connection;
    private volatile int streamId;

    protected Message(Type type) {
        this.type = type;
    }

    public void attach(Connection connection) {
        this.connection = connection;
    }

    public Connection connection() {
        return this.connection;
    }

    public Message setStreamId(int streamId) {
        this.streamId = streamId;
        return this;
    }

    public int getStreamId() {
        return this.streamId;
    }

    static final class UnexpectedChannelExceptionHandler
    implements Predicate<Throwable> {
        private final Channel channel;
        private final boolean alwaysLogAtError;

        UnexpectedChannelExceptionHandler(Channel channel, boolean alwaysLogAtError) {
            this.channel = channel;
            this.alwaysLogAtError = alwaysLogAtError;
        }

        public boolean apply(Throwable exception) {
            String message;
            try {
                message = "Unexpected exception during request; channel = " + this.channel;
            }
            catch (Exception ignore) {
                message = "Unexpected exception during request; channel = <unprintable>";
            }
            if (!this.alwaysLogAtError && exception instanceof IOException) {
                if (ioExceptionsAtDebugLevel.contains(exception.getMessage())) {
                    logger.debug(message, exception);
                } else {
                    logger.info(message, exception);
                }
            } else {
                logger.error(message, exception);
            }
            return true;
        }
    }

    public static class Dispatcher
    extends SimpleChannelUpstreamHandler {
        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
            assert (e.getMessage() instanceof Message) : "Expecting message, got " + e.getMessage();
            if (e.getMessage() instanceof Response) {
                throw new ProtocolException("Invalid response message received, expecting requests");
            }
            Request request = (Request)e.getMessage();
            try {
                assert (request.connection() instanceof ServerConnection);
                ServerConnection connection = (ServerConnection)request.connection();
                QueryState qstate = connection.validateNewMessage(request.type, connection.getVersion(), request.getStreamId());
                logger.debug("Received: {}, v={}", (Object)request, (Object)connection.getVersion());
                Response response = request.execute(qstate);
                response.setStreamId(request.getStreamId());
                response.attach(connection);
                connection.applyStateTransition(request.type, response.type);
                logger.debug("Responding: {}, v={}", (Object)response, (Object)connection.getVersion());
                ctx.getChannel().write((Object)response);
            }
            catch (Throwable ex) {
                ctx.getChannel().write((Object)ErrorMessage.fromException(ex, new UnexpectedChannelExceptionHandler(ctx.getChannel(), true)).setStreamId(request.getStreamId()));
            }
        }

        public void exceptionCaught(final ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            if (ctx.getChannel().isOpen()) {
                ChannelFuture future = ctx.getChannel().write((Object)ErrorMessage.fromException(e.getCause(), new UnexpectedChannelExceptionHandler(ctx.getChannel(), false)));
                if (e.getCause() instanceof ProtocolException) {
                    future.addListener(new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) {
                            ctx.getChannel().close();
                        }
                    });
                }
            }
        }
    }

    public static class ProtocolEncoder
    extends OneToOneEncoder {
        public Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) {
            ChannelBuffer body;
            assert (msg instanceof Message) : "Expecting message, got " + msg;
            Message message = (Message)msg;
            Connection connection = (Connection)channel.getAttachment();
            int version = connection == null ? 2 : connection.getVersion();
            EnumSet<Frame.Header.Flag> flags = EnumSet.noneOf(Frame.Header.Flag.class);
            Codec<?> codec = message.type.codec;
            int messageSize = codec.encodedSize(message, version);
            if (message instanceof Response) {
                UUID tracingId = ((Response)message).getTracingId();
                if (tracingId != null) {
                    body = ChannelBuffers.buffer((int)(CBUtil.sizeOfUUID(tracingId) + messageSize));
                    CBUtil.writeUUID(tracingId, body);
                    flags.add(Frame.Header.Flag.TRACING);
                } else {
                    body = ChannelBuffers.buffer((int)messageSize);
                }
            } else {
                assert (message instanceof Request);
                body = ChannelBuffers.buffer((int)messageSize);
                if (((Request)message).isTracingRequested()) {
                    flags.add(Frame.Header.Flag.TRACING);
                }
            }
            codec.encode(message, body, version);
            return Frame.create(message.type, message.getStreamId(), version, flags, body);
        }
    }

    public static class ProtocolDecoder
    extends OneToOneDecoder {
        public Object decode(ChannelHandlerContext ctx, Channel channel, Object msg) {
            assert (msg instanceof Frame) : "Expecting frame, got " + msg;
            Frame frame = (Frame)msg;
            boolean isRequest = frame.header.type.direction == Direction.REQUEST;
            boolean isTracing = frame.header.flags.contains((Object)Frame.Header.Flag.TRACING);
            UUID tracingId = isRequest || !isTracing ? null : CBUtil.readUUID(frame.body);
            try {
                Message message = (Message)frame.header.type.codec.decode(frame.body, frame.header.version);
                message.setStreamId(frame.header.streamId);
                if (isRequest) {
                    assert (message instanceof Request);
                    Request req = (Request)message;
                    req.attach((Connection)channel.getAttachment());
                    if (isTracing) {
                        req.setTracingRequested();
                    }
                } else {
                    assert (message instanceof Response);
                    if (isTracing) {
                        ((Response)message).setTracingId(tracingId);
                    }
                }
                return message;
            }
            catch (Exception ex) {
                throw ErrorMessage.wrap(ex, frame.header.streamId);
            }
        }
    }

    public static abstract class Response
    extends Message {
        protected UUID tracingId;

        protected Response(Type type) {
            super(type);
            if (type.direction != Direction.RESPONSE) {
                throw new IllegalArgumentException();
            }
        }

        public Message setTracingId(UUID tracingId) {
            this.tracingId = tracingId;
            return this;
        }

        public UUID getTracingId() {
            return this.tracingId;
        }
    }

    public static abstract class Request
    extends Message {
        protected boolean tracingRequested;

        protected Request(Type type) {
            super(type);
            if (type.direction != Direction.REQUEST) {
                throw new IllegalArgumentException();
            }
        }

        public abstract Response execute(QueryState var1);

        public void setTracingRequested() {
            this.tracingRequested = true;
        }

        public boolean isTracingRequested() {
            return this.tracingRequested;
        }
    }

    public static enum Type {
        ERROR(0, Direction.RESPONSE, ErrorMessage.codec),
        STARTUP(1, Direction.REQUEST, StartupMessage.codec),
        READY(2, Direction.RESPONSE, ReadyMessage.codec),
        AUTHENTICATE(3, Direction.RESPONSE, AuthenticateMessage.codec),
        CREDENTIALS(4, Direction.REQUEST, CredentialsMessage.codec),
        OPTIONS(5, Direction.REQUEST, OptionsMessage.codec),
        SUPPORTED(6, Direction.RESPONSE, SupportedMessage.codec),
        QUERY(7, Direction.REQUEST, QueryMessage.codec),
        RESULT(8, Direction.RESPONSE, ResultMessage.codec),
        PREPARE(9, Direction.REQUEST, PrepareMessage.codec),
        EXECUTE(10, Direction.REQUEST, ExecuteMessage.codec),
        REGISTER(11, Direction.REQUEST, RegisterMessage.codec),
        EVENT(12, Direction.RESPONSE, EventMessage.codec),
        BATCH(13, Direction.REQUEST, BatchMessage.codec),
        AUTH_CHALLENGE(14, Direction.RESPONSE, AuthChallenge.codec),
        AUTH_RESPONSE(15, Direction.REQUEST, AuthResponse.codec),
        AUTH_SUCCESS(16, Direction.RESPONSE, AuthSuccess.codec);

        public final int opcode;
        public final Direction direction;
        public final Codec<?> codec;
        private static final Type[] opcodeIdx;

        private Type(int opcode, Direction direction, Codec<?> codec) {
            this.opcode = opcode;
            this.direction = direction;
            this.codec = codec;
        }

        public static Type fromOpcode(int opcode, Direction direction) {
            if (opcode >= opcodeIdx.length) {
                throw new ProtocolException(String.format("Unknown opcode %d", opcode));
            }
            Type t = opcodeIdx[opcode];
            if (t == null) {
                throw new ProtocolException(String.format("Unknown opcode %d", opcode));
            }
            if (t.direction != direction) {
                throw new ProtocolException(String.format("Wrong protocol direction (expected %s, got %s) for opcode %d (%s)", new Object[]{t.direction, direction, opcode, t}));
            }
            return t;
        }

        static {
            int maxOpcode = -1;
            for (Type type : Type.values()) {
                maxOpcode = Math.max(maxOpcode, type.opcode);
            }
            opcodeIdx = new Type[maxOpcode + 1];
            for (Type type : Type.values()) {
                if (opcodeIdx[type.opcode] != null) {
                    throw new IllegalStateException("Duplicate opcode");
                }
                Type.opcodeIdx[type.opcode] = type;
            }
        }
    }

    public static enum Direction {
        REQUEST,
        RESPONSE;


        public static Direction extractFromVersion(int versionWithDirection) {
            return (versionWithDirection & 0x80) == 0 ? REQUEST : RESPONSE;
        }

        public int addToVersion(int rawVersion) {
            return this == REQUEST ? rawVersion & 0x7F : rawVersion | 0x80;
        }
    }

    public static interface Codec<M extends Message>
    extends CBCodec<M> {
    }
}

