/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages;

import com.netflix.astyanax.shaded.org.apache.cassandra.auth.AuthenticatedUser;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.DatabaseDescriptor;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.AuthenticationException;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.QueryState;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.CBUtil;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.Message;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.ProtocolException;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.ErrorMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.ReadyMessage;
import java.util.HashMap;
import java.util.Map;
import org.jboss.netty.buffer.ChannelBuffer;

public class CredentialsMessage
extends Message.Request {
    public static final Message.Codec<CredentialsMessage> codec = new Message.Codec<CredentialsMessage>(){

        @Override
        public CredentialsMessage decode(ChannelBuffer body, int version) {
            if (version > 1) {
                throw new ProtocolException("Legacy credentials authentication is not supported in protocol versions > 1. Please use SASL authentication via a SaslResponse message");
            }
            Map<String, String> credentials = CBUtil.readStringMap(body);
            return new CredentialsMessage(credentials);
        }

        @Override
        public void encode(CredentialsMessage msg, ChannelBuffer dest, int version) {
            CBUtil.writeStringMap(msg.credentials, dest);
        }

        @Override
        public int encodedSize(CredentialsMessage msg, int version) {
            return CBUtil.sizeOfStringMap(msg.credentials);
        }
    };
    public final Map<String, String> credentials;

    public CredentialsMessage() {
        this(new HashMap<String, String>());
    }

    private CredentialsMessage(Map<String, String> credentials) {
        super(Message.Type.CREDENTIALS);
        this.credentials = credentials;
    }

    @Override
    public Message.Response execute(QueryState state) {
        try {
            AuthenticatedUser user = DatabaseDescriptor.getAuthenticator().authenticate(this.credentials);
            state.getClientState().login(user);
            return new ReadyMessage();
        }
        catch (AuthenticationException e) {
            return ErrorMessage.fromException(e);
        }
    }

    public String toString() {
        return "CREDENTIALS";
    }
}

