/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ConsistencyLevel;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.WriteType;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.AlreadyExistsException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.AuthenticationException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.ConfigurationException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.ExceptionCode;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.InvalidRequestException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.IsBootstrappingException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.OverloadedException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.PreparedQueryNotFoundException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.ReadTimeoutException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.RequestTimeoutException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.SyntaxException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.TransportException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.TruncateException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.UnauthorizedException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.UnavailableException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.WriteTimeoutException;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.CBUtil;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.Message;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.ProtocolException;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.ServerError;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.MD5Digest;
import org.jboss.netty.buffer.ChannelBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorMessage
extends Message.Response {
    private static final Logger logger = LoggerFactory.getLogger(ErrorMessage.class);
    public static final Message.Codec<ErrorMessage> codec = new Message.Codec<ErrorMessage>(){

        @Override
        public ErrorMessage decode(ChannelBuffer body, int version) {
            ExceptionCode code = ExceptionCode.fromValue(body.readInt());
            String msg = CBUtil.readString(body);
            Exception te = null;
            switch (code) {
                case SERVER_ERROR: {
                    te = new ServerError(msg);
                    break;
                }
                case PROTOCOL_ERROR: {
                    te = new ProtocolException(msg);
                    break;
                }
                case BAD_CREDENTIALS: {
                    te = new AuthenticationException(msg);
                    break;
                }
                case UNAVAILABLE: {
                    ConsistencyLevel cl = CBUtil.readConsistencyLevel(body);
                    int required = body.readInt();
                    int alive = body.readInt();
                    te = new UnavailableException(cl, required, alive);
                    break;
                }
                case OVERLOADED: {
                    te = new OverloadedException(msg);
                    break;
                }
                case IS_BOOTSTRAPPING: {
                    te = new IsBootstrappingException();
                    break;
                }
                case TRUNCATE_ERROR: {
                    te = new TruncateException(msg);
                    break;
                }
                case WRITE_TIMEOUT: 
                case READ_TIMEOUT: {
                    ConsistencyLevel cl = CBUtil.readConsistencyLevel(body);
                    int received = body.readInt();
                    int blockFor = body.readInt();
                    if (code == ExceptionCode.WRITE_TIMEOUT) {
                        WriteType writeType = Enum.valueOf(WriteType.class, CBUtil.readString(body));
                        te = new WriteTimeoutException(writeType, cl, received, blockFor);
                        break;
                    }
                    byte dataPresent = body.readByte();
                    te = new ReadTimeoutException(cl, received, blockFor, dataPresent != 0);
                    break;
                }
                case UNPREPARED: {
                    MD5Digest id = MD5Digest.wrap(CBUtil.readBytes(body));
                    te = new PreparedQueryNotFoundException(id);
                    break;
                }
                case SYNTAX_ERROR: {
                    te = new SyntaxException(msg);
                    break;
                }
                case UNAUTHORIZED: {
                    te = new UnauthorizedException(msg);
                    break;
                }
                case INVALID: {
                    te = new InvalidRequestException(msg);
                    break;
                }
                case CONFIG_ERROR: {
                    te = new ConfigurationException(msg);
                    break;
                }
                case ALREADY_EXISTS: {
                    String ksName = CBUtil.readString(body);
                    String cfName = CBUtil.readString(body);
                    te = cfName.isEmpty() ? new AlreadyExistsException(ksName) : new AlreadyExistsException(ksName, cfName);
                }
            }
            return new ErrorMessage((TransportException)((Object)te));
        }

        @Override
        public void encode(ErrorMessage msg, ChannelBuffer dest, int version) {
            dest.writeInt(msg.error.code().value);
            CBUtil.writeString(msg.error.getMessage(), dest);
            switch (msg.error.code()) {
                case UNAVAILABLE: {
                    UnavailableException ue = (UnavailableException)msg.error;
                    CBUtil.writeConsistencyLevel(ue.consistency, dest);
                    dest.writeInt(ue.required);
                    dest.writeInt(ue.alive);
                    break;
                }
                case WRITE_TIMEOUT: 
                case READ_TIMEOUT: {
                    RequestTimeoutException rte = (RequestTimeoutException)msg.error;
                    boolean isWrite = msg.error.code() == ExceptionCode.WRITE_TIMEOUT;
                    CBUtil.writeConsistencyLevel(rte.consistency, dest);
                    dest.writeInt(rte.received);
                    dest.writeInt(rte.blockFor);
                    if (isWrite) {
                        CBUtil.writeString(((WriteTimeoutException)rte).writeType.toString(), dest);
                        break;
                    }
                    dest.writeByte((int)((byte)(((ReadTimeoutException)rte).dataPresent ? 1 : 0)));
                    break;
                }
                case UNPREPARED: {
                    PreparedQueryNotFoundException pqnfe = (PreparedQueryNotFoundException)msg.error;
                    CBUtil.writeBytes(pqnfe.id.bytes, dest);
                    break;
                }
                case ALREADY_EXISTS: {
                    AlreadyExistsException aee = (AlreadyExistsException)msg.error;
                    CBUtil.writeString(aee.ksName, dest);
                    CBUtil.writeString(aee.cfName, dest);
                }
            }
        }

        @Override
        public int encodedSize(ErrorMessage msg, int version) {
            int size = 4 + CBUtil.sizeOfString(msg.error.getMessage());
            switch (msg.error.code()) {
                case UNAVAILABLE: {
                    UnavailableException ue = (UnavailableException)msg.error;
                    size += CBUtil.sizeOfConsistencyLevel(ue.consistency) + 8;
                    break;
                }
                case WRITE_TIMEOUT: 
                case READ_TIMEOUT: {
                    RequestTimeoutException rte = (RequestTimeoutException)msg.error;
                    boolean isWrite = msg.error.code() == ExceptionCode.WRITE_TIMEOUT;
                    size += CBUtil.sizeOfConsistencyLevel(rte.consistency) + 8;
                    size += isWrite ? CBUtil.sizeOfString(((WriteTimeoutException)rte).writeType.toString()) : 1;
                    break;
                }
                case UNPREPARED: {
                    PreparedQueryNotFoundException pqnfe = (PreparedQueryNotFoundException)msg.error;
                    size += CBUtil.sizeOfBytes(pqnfe.id.bytes);
                    break;
                }
                case ALREADY_EXISTS: {
                    AlreadyExistsException aee = (AlreadyExistsException)msg.error;
                    size += CBUtil.sizeOfString(aee.ksName);
                    size += CBUtil.sizeOfString(aee.cfName);
                }
            }
            return size;
        }
    };
    public final TransportException error;

    private ErrorMessage(TransportException error) {
        super(Message.Type.ERROR);
        this.error = error;
    }

    private ErrorMessage(TransportException error, int streamId) {
        this(error);
        this.setStreamId(streamId);
    }

    public static ErrorMessage fromException(Throwable e) {
        return ErrorMessage.fromException(e, null);
    }

    public static ErrorMessage fromException(Throwable e, Predicate<Throwable> unexpectedExceptionHandler) {
        int streamId = 0;
        if (e instanceof WrappedException) {
            streamId = ((WrappedException)e).streamId;
            e = e.getCause();
        }
        if (e instanceof TransportException) {
            return new ErrorMessage((TransportException)((Object)e), streamId);
        }
        if (unexpectedExceptionHandler == null || !unexpectedExceptionHandler.apply((Object)e)) {
            logger.error("Unexpected exception during request", e);
        }
        return new ErrorMessage((TransportException)new ServerError(e), streamId);
    }

    public String toString() {
        return "ERROR " + (Object)((Object)this.error.code()) + ": " + this.error.getMessage();
    }

    public static RuntimeException wrap(Throwable t, int streamId) {
        return new WrappedException(t, streamId);
    }

    @VisibleForTesting
    public static class WrappedException
    extends RuntimeException {
        private final int streamId;

        public WrappedException(Throwable cause, int streamId) {
            super(cause);
            this.streamId = streamId;
        }

        public int getStreamId() {
            return this.streamId;
        }
    }
}

