/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.janus.migration;

import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.janus.migration.GraphSONUtility;
import org.apache.atlas.repository.graphdb.janus.migration.MappedElementCache;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.shaded.jackson.databind.JsonNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonNodeParsers {
    private static final Logger LOG = LoggerFactory.getLogger(JsonNodeParsers.class);

    static class ParseVertex
    extends ParseElement {
        private static final String NODE_VALUE_KEY = "value";
        private static final String MESSAGE_VERTEX = "vertex";

        ParseVertex() {
        }

        @Override
        public String getMessage() {
            return MESSAGE_VERTEX;
        }

        @Override
        Object getId(JsonNode node) {
            return GraphSONUtility.getTypedValueFromJsonNode(node.get("_id"));
        }

        @Override
        public Map<String, Object> parse(Graph graph, MappedElementCache cache, JsonNode node) {
            return this.utility.vertexFromJson(graph, node);
        }

        @Override
        Element get(Graph gr, Object id) {
            return (Element)gr.vertices(new Object[]{id}).next();
        }

        @Override
        Element getByOriginalId(Graph gr, Object id) {
            try {
                return (Element)gr.traversal().V(new Object[0]).has("__vIdInImport", id).next();
            }
            catch (NoSuchElementException ex) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("getByOriginalId: {}: failed: {}", new Object[]{this.getMessage(), id, ex});
                }
            }
            catch (Exception ex) {
                LOG.error("getByOriginalId: {}: failed: {}", new Object[]{this.getMessage(), id, ex});
            }
            return null;
        }

        @Override
        public boolean isTypeNode(JsonNode node) {
            return node.has(Constants.TYPENAME_PROPERTY_KEY);
        }

        @Override
        public String getType(JsonNode node) {
            return node.has(Constants.ENTITY_TYPE_PROPERTY_KEY) ? node.get(Constants.ENTITY_TYPE_PROPERTY_KEY).get(NODE_VALUE_KEY).toString() : "";
        }
    }

    static class ParseEdge
    extends ParseElement {
        private static final String MESSAGE_EDGE = "edge";

        ParseEdge() {
        }

        @Override
        public String getMessage() {
            return MESSAGE_EDGE;
        }

        @Override
        Object getId(JsonNode node) {
            return GraphSONUtility.getTypedValueFromJsonNode(node.get("_id"));
        }

        @Override
        public Map<String, Object> parse(Graph gr, MappedElementCache cache, JsonNode node) {
            return this.utility.edgeFromJson(gr, cache, node);
        }

        @Override
        Element get(Graph gr, Object id) {
            return (Element)gr.edges(new Object[]{id}).next();
        }

        @Override
        Element getByOriginalId(Graph gr, Object id) {
            try {
                return (Element)gr.traversal().E(new Object[0]).has("__eIdInImport", id).next();
            }
            catch (NoSuchElementException ex) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("getByOriginalId: {}: failed: {}", new Object[]{this.getMessage(), id, ex});
                }
            }
            catch (Exception ex) {
                LOG.error("getByOriginalId: {}: failed: {}", new Object[]{this.getMessage(), id, ex});
            }
            return null;
        }

        @Override
        public boolean isTypeNode(JsonNode node) {
            return node.get("_label").textValue().startsWith(Constants.TYPENAME_PROPERTY_KEY);
        }

        @Override
        public String getType(JsonNode node) {
            return node.get("_label").textValue();
        }
    }

    static abstract class ParseElement {
        protected GraphSONUtility utility;

        ParseElement() {
        }

        abstract String getMessage();

        abstract Object getId(JsonNode var1);

        abstract boolean isTypeNode(JsonNode var1);

        abstract String getType(JsonNode var1);

        public void setContext(GraphSONUtility utility) {
            this.utility = utility;
        }

        abstract Map<String, Object> parse(Graph var1, MappedElementCache var2, JsonNode var3);

        public void commit(Graph graph) {
            graph.tx().commit();
        }

        abstract Element get(Graph var1, Object var2);

        abstract Element getByOriginalId(Graph var1, Object var2);

        public Element getByOriginalId(Graph gr, JsonNode node) {
            return this.getByOriginalId(gr, this.getId(node));
        }

        public Element update(Graph gr, Object id, Map<String, Object> schema) {
            Element el = this.get(gr, id);
            for (Map.Entry<String, Object> entry : schema.entrySet()) {
                el.property(entry.getKey(), entry.getValue());
            }
            return el;
        }
    }
}

