/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasEntityUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasEntityUtil.class);
    private static final String SOFT_REFERENCE_FORMAT_SEPERATOR = ":";
    private static final String SOFT_REF_FORMAT = "%s:%s";
    private static final int SOFT_REFERENCE_FORMAT_INDEX_TYPE_NAME = 0;
    private static final int SOFT_REFERENCE_FORMAT_INDEX_GUID = 1;

    public static String formatSoftRefValue(String typeName, String guid) {
        return String.format(SOFT_REF_FORMAT, typeName, guid);
    }

    public static String formatSoftRefValue(AtlasObjectId objectId) {
        return AtlasEntityUtil.formatSoftRefValue(objectId.getTypeName(), objectId.getGuid());
    }

    public static List<String> formatSoftRefValue(List<AtlasObjectId> objIds) {
        ArrayList<String> ret = new ArrayList<String>();
        for (AtlasObjectId objId : objIds) {
            ret.add(AtlasEntityUtil.formatSoftRefValue(objId));
        }
        return ret;
    }

    public static Map<String, String> formatSoftRefValue(Map<String, AtlasObjectId> objIdMap) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (Map.Entry<String, AtlasObjectId> entry : objIdMap.entrySet()) {
            ret.put(entry.getKey(), AtlasEntityUtil.formatSoftRefValue(entry.getValue()));
        }
        return ret;
    }

    public static AtlasObjectId parseSoftRefValue(String softRefValue) {
        AtlasObjectId ret = null;
        if (StringUtils.isNotEmpty((String)softRefValue)) {
            String[] objectIdParts = StringUtils.split((String)softRefValue, (String)SOFT_REFERENCE_FORMAT_SEPERATOR);
            if (objectIdParts.length >= 2) {
                ret = new AtlasObjectId(objectIdParts[1], objectIdParts[0]);
            } else {
                LOG.warn("Invalid soft-ref value: {}", (Object)softRefValue);
            }
        }
        return ret;
    }

    public static List<AtlasObjectId> parseSoftRefValue(List<String> softRefValue) {
        ArrayList<AtlasObjectId> ret = null;
        if (CollectionUtils.isNotEmpty(softRefValue)) {
            ret = new ArrayList<AtlasObjectId>();
            for (String elemValue : softRefValue) {
                AtlasObjectId objId = AtlasEntityUtil.parseSoftRefValue(elemValue);
                if (objId == null) continue;
                ret.add(objId);
            }
        }
        return ret;
    }

    public static Map<String, AtlasObjectId> parseSoftRefValue(Map<String, String> softRefValue) {
        HashMap<String, AtlasObjectId> ret = null;
        if (MapUtils.isNotEmpty(softRefValue)) {
            ret = new HashMap<String, AtlasObjectId>();
            for (Map.Entry<String, String> entry : softRefValue.entrySet()) {
                AtlasObjectId objId = AtlasEntityUtil.parseSoftRefValue(entry.getValue());
                if (objId == null) continue;
                ret.put(entry.getKey(), objId);
            }
        }
        return ret;
    }

    public static String getRelationshipType(Object val) {
        String ret;
        if (val instanceof AtlasRelatedObjectId) {
            ret = ((AtlasRelatedObjectId)val).getRelationshipType();
        } else if (val instanceof Collection) {
            Object elem;
            String elemRelationshipType = null;
            Iterator iterator = ((Collection)val).iterator();
            while (iterator.hasNext() && (elemRelationshipType = AtlasEntityUtil.getRelationshipType(elem = iterator.next())) == null) {
            }
            ret = elemRelationshipType;
        } else if (val instanceof Map) {
            Map mapValue = (Map)val;
            if (mapValue.containsKey("relationshipType")) {
                Object relTypeName = ((Map)val).get("relationshipType");
                ret = relTypeName != null ? relTypeName.toString() : null;
            } else {
                Object entryVal;
                String entryRelationshipType = null;
                Iterator iterator = mapValue.values().iterator();
                while (iterator.hasNext() && (entryRelationshipType = AtlasEntityUtil.getRelationshipType(entryVal = iterator.next())) == null) {
                }
                ret = entryRelationshipType;
            }
        } else {
            ret = null;
        }
        return ret;
    }
}

